/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDOMRpcResultFuture;
import org.opendaylight.mdsal.binding.dom.adapter.StaticConfiguration;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingLazyContainerNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractDOMRpcImplementationAdapter
implements DOMRpcImplementation {
    private final AdapterContext adapterContext;
    private final @NonNull QName inputName;
    private final @NonNull QName rpcName;

    AbstractDOMRpcImplementationAdapter(AdapterContext adapterContext, QName rpcName) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.rpcName = Objects.requireNonNull(rpcName);
        this.inputName = YangConstants.operationInputQName((QNameModule)rpcName.getModule()).intern();
    }

    public final long invocationCost() {
        return 1L;
    }

    public final ListenableFuture<DOMRpcResult> invokeRpc(DOMRpcIdentifier rpc, ContainerNode input) {
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        return LazyDOMRpcResultFuture.create((BindingNormalizedNodeSerializer)serializer, this.invokeRpc(this.deserialize(serializer, input)));
    }

    abstract @NonNull ListenableFuture<RpcResult<?>> invokeRpc(@NonNull RpcInput var1);

    private @NonNull RpcInput deserialize(@NonNull CurrentAdapterSerializer serializer, @NonNull ContainerNode input) {
        if (StaticConfiguration.ENABLE_CODEC_SHORTCUT && input instanceof BindingLazyContainerNode) {
            BindingLazyContainerNode lazy = (BindingLazyContainerNode)input;
            return (RpcInput)lazy.getDataObject();
        }
        Preconditions.checkArgument((boolean)this.inputName.equals((Object)input.name().getNodeType()), (String)"Unexpected RPC %s input %s", (Object)this.rpcName, (Object)input);
        return (RpcInput)Verify.verifyNotNull((Object)((RpcInput)serializer.fromNormalizedNodeRpcData(SchemaNodeIdentifier.Absolute.of((QName[])new QName[]{this.rpcName, this.inputName}), input)));
    }
}

