/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.dom.adapter.BindingStructuralType;
import org.opendaylight.mdsal.binding.dom.adapter.LazyAugmentationModification;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataObjectModification;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataContainerCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractDataObjectModification<T extends DataObject, N extends CommonDataObjectCodecTreeNode<T>>
implements DataObjectModification<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataObjectModification.class);
    private static final @NonNull Object NULL_DATA_OBJECT = new Object();
    private static final VarHandle MODIFICATION_TYPE;
    private static final VarHandle MODIFIED_CHILDREN;
    private static final VarHandle DATA_BEFORE;
    private static final VarHandle DATA_AFTER;
    final @NonNull DataTreeCandidateNode domData;
    final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull InstanceIdentifier.PathArgument identifier;
    final @NonNull N codec;
    private volatile ImmutableList<AbstractDataObjectModification<?, ?>> modifiedChildren;
    private volatile DataObjectModification.ModificationType modificationType;
    private volatile Object dataBefore;
    private volatile Object dataAfter;

    AbstractDataObjectModification(DataTreeCandidateNode domData, N codec, InstanceIdentifier.PathArgument identifier) {
        this.domData = Objects.requireNonNull(domData);
        this.identifier = Objects.requireNonNull(identifier);
        this.codec = (CommonDataObjectCodecTreeNode)Objects.requireNonNull(codec);
    }

    static @Nullable AbstractDataObjectModification<?, ?> from(CommonDataObjectCodecTreeNode<?> codec, @NonNull DataTreeCandidateNode current) {
        if (codec instanceof BindingDataObjectCodecTreeNode) {
            BindingDataObjectCodecTreeNode childDataObjectCodec = (BindingDataObjectCodecTreeNode)codec;
            return new LazyDataObjectModification(childDataObjectCodec, current);
        }
        if (codec instanceof BindingAugmentationCodecTreeNode) {
            BindingAugmentationCodecTreeNode childAugmentationCodec = (BindingAugmentationCodecTreeNode)codec;
            return LazyAugmentationModification.forParent(childAugmentationCodec, current);
        }
        throw new VerifyException("Unhandled codec " + codec);
    }

    public final Class<T> getDataType() {
        return this.codec.getBindingClass();
    }

    public final InstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    public final DataObjectModification.ModificationType getModificationType() {
        DataObjectModification.ModificationType local = MODIFICATION_TYPE.getAcquire(this);
        return local != null ? local : this.loadModificationType();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull DataObjectModification.ModificationType loadModificationType() {
        ModificationType domModificationType = this.domModificationType();
        DataObjectModification.ModificationType computed = switch (domModificationType) {
            case ModificationType.APPEARED, ModificationType.WRITE -> DataObjectModification.ModificationType.WRITE;
            case ModificationType.DISAPPEARED, ModificationType.DELETE -> DataObjectModification.ModificationType.DELETE;
            case ModificationType.SUBTREE_MODIFIED -> this.resolveSubtreeModificationType();
            default -> throw new IllegalStateException("Unsupported DOM Modification type " + domModificationType);
        };
        MODIFICATION_TYPE.setRelease(this, computed);
        return computed;
    }

    public final T getDataBefore() {
        Object local = DATA_BEFORE.getAcquire(this);
        return local != null ? this.unmask(local) : this.loadDataBefore();
    }

    private @Nullable T loadDataBefore() {
        T computed = this.deserializeNullable(this.domData.dataBefore());
        Object witness = DATA_BEFORE.compareAndExchangeRelease(this, null, AbstractDataObjectModification.mask(computed));
        return witness == null ? computed : this.unmask(witness);
    }

    public final T getDataAfter() {
        Object local = DATA_AFTER.getAcquire(this);
        return local != null ? this.unmask(local) : this.loadDataAfter();
    }

    private @Nullable T loadDataAfter() {
        T computed = this.deserializeNullable(this.domData.dataAfter());
        Object witness = DATA_AFTER.compareAndExchangeRelease(this, null, AbstractDataObjectModification.mask(computed));
        return witness == null ? computed : this.unmask(witness);
    }

    private static <T extends DataObject> @NonNull Object mask(@Nullable T obj) {
        return obj != null ? obj : NULL_DATA_OBJECT;
    }

    private @Nullable T unmask(@NonNull Object obj) {
        return (T)(obj == NULL_DATA_OBJECT ? null : (DataObject)Verify.verifyNotNull((Object)obj));
    }

    private @Nullable T deserializeNullable(@Nullable NormalizedNode normalized) {
        return normalized == null ? null : (T)this.deserialize(normalized);
    }

    abstract @Nullable T deserialize(@NonNull NormalizedNode var1);

    public final DataObjectModification<?> getModifiedChild(InstanceIdentifier.PathArgument arg) {
        DataTreeCandidateNode current;
        ArrayList domArgumentList = new ArrayList();
        CommonDataObjectCodecTreeNode childCodec = this.codec.bindingPathArgumentChild(arg, domArgumentList);
        Iterator toEnter = domArgumentList.iterator();
        DataTreeCandidateNode dataTreeCandidateNode = current = toEnter.hasNext() ? this.firstModifiedChild((YangInstanceIdentifier.PathArgument)toEnter.next()) : this.domData;
        while (toEnter.hasNext() && current != null) {
            current = current.modifiedChild((YangInstanceIdentifier.PathArgument)toEnter.next());
        }
        if (current == null || current.modificationType() == ModificationType.UNMODIFIED) {
            return null;
        }
        return AbstractDataObjectModification.from(childCodec, current);
    }

    abstract @Nullable DataTreeCandidateNode firstModifiedChild(YangInstanceIdentifier.PathArgument var1);

    public final ImmutableList<AbstractDataObjectModification<?, ?>> getModifiedChildren() {
        ImmutableList<AbstractDataObjectModification<?, ?>> local = MODIFIED_CHILDREN.getAcquire(this);
        return local != null ? local : this.loadModifiedChilden();
    }

    public final <C extends ChildOf<? super T>> List<DataObjectModification<C>> getModifiedChildren(Class<C> childType) {
        return this.streamModifiedChildren(childType).collect(Collectors.toList());
    }

    public final <H extends ChoiceIn<? super T> & DataObject, C extends ChildOf<? super H>> List<DataObjectModification<C>> getModifiedChildren(Class<H> caseType, Class<C> childType) {
        return this.streamModifiedChildren(childType).filter(child -> caseType.equals(child.identifier.getCaseType().orElse(null))).collect(Collectors.toList());
    }

    private @NonNull ImmutableList<AbstractDataObjectModification<?, ?>> loadModifiedChilden() {
        ImmutableList.Builder builder = ImmutableList.builder();
        AbstractDataObjectModification.populateList(builder, this.codec, this.domData, this.domChildNodes());
        ImmutableList computed = builder.build();
        Object witness = MODIFIED_CHILDREN.compareAndExchangeRelease(this, null, computed);
        return witness == null ? computed : (ImmutableList)witness;
    }

    private <C extends DataObject> Stream<LazyDataObjectModification<C>> streamModifiedChildren(Class<C> childType) {
        return this.getModifiedChildren().stream().filter(child -> childType.isAssignableFrom(child.getDataType())).map(child -> (LazyDataObjectModification)child);
    }

    public final <C extends KeyAware<K> & ChildOf<? super T>, K extends Key<C>> DataObjectModification<C> getModifiedChildListItem(Class<C> listItem, K listKey) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)InstanceIdentifier.IdentifiableItem.of(listItem, listKey));
    }

    public final <H extends ChoiceIn<? super T> & DataObject, C extends KeyAware<K> & ChildOf<? super H>, K extends Key<C>> DataObjectModification<C> getModifiedChildListItem(Class<H> caseType, Class<C> listItem, K listKey) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)InstanceIdentifier.IdentifiableItem.of(caseType, listItem, listKey));
    }

    public final <C extends ChildOf<? super T>> DataObjectModification<C> getModifiedChildContainer(Class<C> child) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)InstanceIdentifier.Item.of(child));
    }

    public final <H extends ChoiceIn<? super T> & DataObject, C extends ChildOf<? super H>> DataObjectModification<C> getModifiedChildContainer(Class<H> caseType, Class<C> child) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)InstanceIdentifier.Item.of(caseType, child));
    }

    public final <C extends Augmentation<T> & DataObject> DataObjectModification<C> getModifiedAugmentation(Class<C> augmentation) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)InstanceIdentifier.Item.of(augmentation));
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("identifier", (Object)this.identifier).add("domData", (Object)this.domData);
    }

    abstract @NonNull Collection<DataTreeCandidateNode> domChildNodes();

    abstract @NonNull ModificationType domModificationType();

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull DataObjectModification.ModificationType resolveSubtreeModificationType() {
        return switch (this.codec.getChildAddressabilitySummary()) {
            default -> throw new IncompatibleClassChangeError();
            case BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.ADDRESSABLE -> DataObjectModification.ModificationType.SUBTREE_MODIFIED;
            case BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE -> DataObjectModification.ModificationType.WRITE;
            case BindingDataContainerCodecTreeNode.ChildAddressabilitySummary.MIXED -> {
                for (DataTreeCandidateNode child : this.domChildNodes()) {
                    if (BindingStructuralType.recursiveFrom(child) != BindingStructuralType.NOT_ADDRESSABLE) continue;
                    yield DataObjectModification.ModificationType.WRITE;
                }
                yield DataObjectModification.ModificationType.SUBTREE_MODIFIED;
            }
        };
    }

    private static void populateList(ImmutableList.Builder<AbstractDataObjectModification<?, ?>> result, CommonDataObjectCodecTreeNode<?> parentCodec, DataTreeCandidateNode parent, Collection<DataTreeCandidateNode> children) {
        ArrayListMultimap augmentChildren = ArrayListMultimap.create();
        for (DataTreeCandidateNode dataTreeCandidateNode : parent.childNodes()) {
            BindingStructuralType type;
            if (dataTreeCandidateNode.modificationType() == ModificationType.UNMODIFIED || (type = BindingStructuralType.from(dataTreeCandidateNode)) == BindingStructuralType.NOT_ADDRESSABLE) continue;
            try {
                BindingCodecTreeNode childCodec = parentCodec.yangPathArgumentChild(dataTreeCandidateNode.name());
                if (childCodec instanceof BindingDataObjectCodecTreeNode) {
                    BindingDataObjectCodecTreeNode childDataObjectCodec = (BindingDataObjectCodecTreeNode)childCodec;
                    AbstractDataObjectModification.populateList(result, type, childDataObjectCodec, dataTreeCandidateNode);
                    continue;
                }
                if (childCodec instanceof BindingAugmentationCodecTreeNode) {
                    BindingAugmentationCodecTreeNode childAugmentationCodec = (BindingAugmentationCodecTreeNode)childCodec;
                    augmentChildren.put((Object)childAugmentationCodec, (Object)dataTreeCandidateNode);
                    continue;
                }
                throw new VerifyException("Unhandled codec %s for type %s".formatted(new Object[]{childCodec, type}));
            }
            catch (IllegalArgumentException e) {
                if (type == BindingStructuralType.UNKNOWN) {
                    LOG.debug("Unable to deserialize unknown DOM node {}", (Object)dataTreeCandidateNode, (Object)e);
                    continue;
                }
                LOG.debug("Binding representation for DOM node {} was not found", (Object)dataTreeCandidateNode, (Object)e);
            }
        }
        for (Map.Entry entry : augmentChildren.asMap().entrySet()) {
            LazyAugmentationModification modification = LazyAugmentationModification.forModifications((BindingAugmentationCodecTreeNode)entry.getKey(), parent, (Collection)entry.getValue());
            if (modification == null) continue;
            result.add(modification);
        }
    }

    private static void populateList(ImmutableList.Builder<AbstractDataObjectModification<?, ?>> result, BindingStructuralType type, BindingDataObjectCodecTreeNode<?> childCodec, DataTreeCandidateNode domChildNode) {
        switch (type) {
            case INVISIBLE_LIST: {
                AbstractDataObjectModification.populateListWithSingleCodec(result, childCodec, domChildNode.childNodes());
                break;
            }
            case INVISIBLE_CONTAINER: {
                AbstractDataObjectModification.populateList(result, childCodec, domChildNode, domChildNode.childNodes());
                break;
            }
            case UNKNOWN: 
            case VISIBLE_CONTAINER: {
                result.add(new LazyDataObjectModification(childCodec, domChildNode));
                break;
            }
        }
    }

    private static void populateListWithSingleCodec(ImmutableList.Builder<AbstractDataObjectModification<?, ?>> result, BindingDataObjectCodecTreeNode<?> codec, Collection<DataTreeCandidateNode> childNodes) {
        for (DataTreeCandidateNode child : childNodes) {
            if (child.modificationType() == ModificationType.UNMODIFIED) continue;
            result.add(new LazyDataObjectModification(codec, child));
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MODIFICATION_TYPE = lookup.findVarHandle(AbstractDataObjectModification.class, "modificationType", DataObjectModification.ModificationType.class);
            MODIFIED_CHILDREN = lookup.findVarHandle(AbstractDataObjectModification.class, "modifiedChildren", ImmutableList.class);
            DATA_BEFORE = lookup.findVarHandle(AbstractDataObjectModification.class, "dataBefore", Object.class);
            DATA_AFTER = lookup.findVarHandle(AbstractDataObjectModification.class, "dataAfter", Object.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

