/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.api.query.QueryResult;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQuery;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeQueryOperations;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadOperations;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.query.DOMQuery;
import org.opendaylight.mdsal.dom.api.query.DOMQueryResult;
import org.opendaylight.mdsal.dom.spi.query.DOMQueryEvaluator;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractForwardedTransaction<T extends DOMDataTreeTransaction>
implements Delegator<T>,
Identifiable<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractForwardedTransaction.class);
    private final @NonNull AdapterContext adapterContext;
    private final @NonNull T delegate;

    AbstractForwardedTransaction(AdapterContext adapterContext, T delegateTx) {
        this.adapterContext = Objects.requireNonNull(adapterContext, "Codec must not be null");
        this.delegate = (DOMDataTreeTransaction)Objects.requireNonNull(delegateTx, "Delegate must not be null");
    }

    public final Object getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public final T getDelegate() {
        return this.delegate;
    }

    protected final <S extends DOMDataTreeTransaction> S getDelegateChecked(Class<S> txType) {
        Preconditions.checkState((boolean)txType.isInstance(this.delegate));
        return (S)((DOMDataTreeTransaction)txType.cast(this.delegate));
    }

    protected final AdapterContext adapterContext() {
        return this.adapterContext;
    }

    protected final <D extends DataObject> @NonNull FluentFuture<Optional<D>> doRead(DOMDataTreeReadOperations readOps, LogicalDatastoreType store, InstanceIdentifier<D> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Invalid read of wildcarded path %s", path);
        BindingCodecTree.CodecWithPath codecWithPath = this.adapterContext.currentSerializer().getSubtreeCodecWithPath(path);
        YangInstanceIdentifier domPath = codecWithPath.path();
        CommonDataObjectCodecTreeNode codec = codecWithPath.codec();
        return readOps.read(store, domPath).transform(optData -> optData.flatMap(data -> AbstractForwardedTransaction.decodeRead(codec, data)), MoreExecutors.directExecutor());
    }

    private static <D extends DataObject> Optional<D> decodeRead(CommonDataObjectCodecTreeNode<D> codec, @NonNull NormalizedNode data) {
        if (codec instanceof BindingDataObjectCodecTreeNode) {
            BindingDataObjectCodecTreeNode dataObject = (BindingDataObjectCodecTreeNode)codec;
            return Optional.of((DataObject)dataObject.deserialize(data));
        }
        if (codec instanceof BindingAugmentationCodecTreeNode) {
            BindingAugmentationCodecTreeNode augment = (BindingAugmentationCodecTreeNode)codec;
            return Optional.ofNullable(augment.filterFrom(data));
        }
        throw new VerifyException("Unhandled codec " + codec);
    }

    protected final @NonNull FluentFuture<Boolean> doExists(DOMDataTreeReadOperations readOps, LogicalDatastoreType store, InstanceIdentifier<?> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Invalid exists of wildcarded path %s", path);
        BindingCodecTree.CodecWithPath codecWithPath = this.adapterContext.currentSerializer().getSubtreeCodecWithPath(path);
        YangInstanceIdentifier domPath = codecWithPath.path();
        CommonDataObjectCodecTreeNode commonDataObjectCodecTreeNode = codecWithPath.codec();
        if (commonDataObjectCodecTreeNode instanceof BindingAugmentationCodecTreeNode) {
            BindingAugmentationCodecTreeNode augment = (BindingAugmentationCodecTreeNode)commonDataObjectCodecTreeNode;
            return FluentFuture.from((ListenableFuture)Futures.transform((ListenableFuture)Futures.allAsList((Iterable)((Iterable)augment.childPathArguments().stream().map(child -> readOps.exists(store, domPath.node((YangInstanceIdentifier.PathArgument)child))).collect(ImmutableList.toImmutableList()))), children -> children.contains(Boolean.TRUE), (Executor)MoreExecutors.directExecutor()));
        }
        return readOps.exists(store, domPath);
    }

    protected static final <T extends DataObject> @NonNull FluentFuture<QueryResult<T>> doExecute(DOMDataTreeReadOperations readOps, @NonNull LogicalDatastoreType store, @NonNull QueryExpression<T> query) {
        FluentFuture fluentFuture;
        Preconditions.checkArgument((boolean)(query instanceof DefaultQuery), (String)"Unsupported query type %s", query);
        DefaultQuery defaultQuery = (DefaultQuery)query;
        DOMDataTreeReadOperations dOMDataTreeReadOperations = Objects.requireNonNull(readOps);
        if (dOMDataTreeReadOperations instanceof DOMDataTreeQueryOperations) {
            DOMDataTreeQueryOperations dtqOps = (DOMDataTreeQueryOperations)dOMDataTreeReadOperations;
            fluentFuture = dtqOps.execute(store, defaultQuery.asDOMQuery());
        } else {
            fluentFuture = AbstractForwardedTransaction.fallbackExecute(readOps, store, defaultQuery.asDOMQuery());
        }
        FluentFuture domFuture = fluentFuture;
        return domFuture.transform(defaultQuery::toQueryResult, MoreExecutors.directExecutor());
    }

    private static FluentFuture<DOMQueryResult> fallbackExecute(@NonNull DOMDataTreeReadOperations readOps, @NonNull LogicalDatastoreType store, @NonNull DOMQuery domQuery) {
        LOG.trace("Fallback evaluation of {} on {}", (Object)domQuery, (Object)readOps);
        return readOps.read(store, domQuery.getRoot()).transform(node -> node.map(data -> DOMQueryEvaluator.evaluateOn((DOMQuery)domQuery, (NormalizedNode)data)).orElse(DOMQueryResult.of()), MoreExecutors.directExecutor());
    }
}

