/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMInstanceNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.yangtools.yang.binding.BaseNotification;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.InstanceNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractInstanceNotificationListenerAdapter<P extends DataObject, N extends InstanceNotification<N, P>, L>
implements DOMInstanceNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInstanceNotificationListenerAdapter.class);
    private final @NonNull AdapterContext adapterContext;
    private final @NonNull Class<N> notificationClass;
    private final @NonNull Executor executor;
    private final @NonNull L delegate;

    AbstractInstanceNotificationListenerAdapter(AdapterContext adapterContext, Class<N> nofiticationClass, L delegate, Executor executor) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.notificationClass = Objects.requireNonNull(nofiticationClass);
        this.delegate = Objects.requireNonNull(delegate);
        this.executor = Objects.requireNonNull(executor);
    }

    public final void onNotification(DOMDataTreeIdentifier path, DOMNotification notification) {
        InstanceNotification castNotification;
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        BaseNotification bindingNotification = notification instanceof DOMEvent ? serializer.fromNormalizedNodeNotification(notification.getType(), notification.getBody(), ((DOMEvent)notification).getEventInstant()) : serializer.fromNormalizedNodeNotification(notification.getType(), notification.getBody());
        try {
            castNotification = (InstanceNotification)this.notificationClass.cast(bindingNotification);
        }
        catch (ClassCastException e) {
            LOG.warn("Mismatched notification type {}, not notifying listener", (Object)notification.getType(), (Object)e);
            return;
        }
        InstanceIdentifier bindingPath = serializer.fromYangInstanceIdentifier(path.getRootIdentifier());
        this.executor.execute(() -> this.onNotification(this.delegate, bindingPath, castNotification));
    }

    abstract void onNotification(@NonNull L var1, @NonNull InstanceIdentifier<?> var2, @NonNull N var3);
}

