/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.ContextReferenceExtractor;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.RpcInvocationStrategy;
import org.opendaylight.mdsal.binding.runtime.api.RpcRuntimeType;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.spi.ContentRoutedRpcContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractRpcAdapter
implements InvocationHandler {
    private final @NonNull DOMRpcService delegate;
    private final @NonNull AdapterContext adapterContext;
    private final @NonNull Object facade;
    private final String name;

    AbstractRpcAdapter(AdapterContext adapterContext, DOMRpcService delegate, Class<?> type) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.delegate = Objects.requireNonNull(delegate);
        this.facade = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)this);
        this.name = type.getName();
    }

    final @NonNull CurrentAdapterSerializer currentSerializer() {
        return this.adapterContext.currentSerializer();
    }

    final @NonNull DOMRpcService delegate() {
        return this.delegate;
    }

    final @NonNull Object facade() {
        return this.facade;
    }

    final @NonNull RpcInvocationStrategy createStrategy(CurrentAdapterSerializer serializer, RpcRuntimeType rpcType) {
        ContextReferenceExtractor extractor;
        RpcEffectiveStatement rpc = rpcType.statement();
        ContentRoutedRpcContext contentContext = ContentRoutedRpcContext.forRpc((RpcEffectiveStatement)rpc);
        if (contentContext != null && (extractor = serializer.findExtractor(rpcType.input())) != null) {
            return new RpcInvocationStrategy.ContentRouted(this, (QName)rpc.argument(), contentContext.leaf(), extractor);
        }
        return new RpcInvocationStrategy(this, (QName)rpc.argument());
    }

    final Object defaultInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "toString": {
                if (!method.getReturnType().equals(String.class) || method.getParameterCount() != 0) break;
                return this.name + "$Adapter{delegate=" + this.delegate() + "}";
            }
            case "hashCode": {
                if (!method.getReturnType().equals(Integer.TYPE) || method.getParameterCount() != 0) break;
                return System.identityHashCode(proxy);
            }
            case "equals": {
                if (!method.getReturnType().equals(Boolean.TYPE) || method.getParameterCount() != 1 || method.getParameterTypes()[0] != Object.class) break;
                return proxy == args[0];
            }
        }
        if (method.isDefault()) {
            return InvocationHandler.invokeDefault(proxy, method, args);
        }
        throw new UnsupportedOperationException("Method " + method.toString() + " is not supported");
    }
}

