/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.ActionAdapter;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

final class ActionAdapterFilter
implements InvocationHandler {
    private final Set<DataTreeIdentifier<?>> nodes;
    private final ActionAdapter delegate;

    ActionAdapterFilter(ActionAdapter delegate, Set<DataTreeIdentifier<?>> nodes) {
        this.delegate = Objects.requireNonNull(delegate);
        this.nodes = Objects.requireNonNull(nodes);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("invoke".equals(method.getName()) && args.length == 2) {
            InstanceIdentifier path = (InstanceIdentifier)Objects.requireNonNull(args[0]);
            Preconditions.checkState((boolean)this.nodes.contains(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)path)), (String)"Cannot service %s", (Object)path);
        }
        return this.delegate.invoke(proxy, method, args);
    }
}

