/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.DataChangeListener;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.mdsal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

final class BindingDOMDataChangeListenerAdapter<T extends DataObject>
implements ClusteredDOMDataTreeChangeListener {
    private final AdapterContext adapterContext;
    private final DataChangeListener<T> listener;

    BindingDOMDataChangeListenerAdapter(AdapterContext adapterContext, DataChangeListener<T> listener) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.listener = Objects.requireNonNull(listener);
    }

    public void onDataTreeChanged(List<DataTreeCandidate> changes) {
        DataTreeCandidate first = changes.get(0);
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        CommonDataObjectCodecTreeNode codec = serializer.getSubtreeCodec(serializer.coerceInstanceIdentifier(first.getRootPath()));
        this.listener.dataChanged(this.deserialize(codec, first.getRootNode().dataBefore()), this.deserialize(codec, changes.get(changes.size() - 1).getRootNode().dataAfter()));
    }

    public void onInitialData() {
        this.listener.dataChanged(null, null);
    }

    private @Nullable T deserialize(CommonDataObjectCodecTreeNode<?> codec, NormalizedNode data) {
        if (data == null) {
            return null;
        }
        if (codec instanceof BindingDataObjectCodecTreeNode) {
            BindingDataObjectCodecTreeNode dataObject = (BindingDataObjectCodecTreeNode)codec;
            return (T)((DataObject)dataObject.deserialize(data));
        }
        if (codec instanceof BindingAugmentationCodecTreeNode) {
            BindingAugmentationCodecTreeNode augmentation = (BindingAugmentationCodecTreeNode)codec;
            return (T)augmentation.filterFrom(data);
        }
        throw new IllegalStateException("Unhandled codec " + codec);
    }
}

