/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

class BindingDOMDataTreeChangeListenerAdapter<T extends DataObject>
implements DOMDataTreeChangeListener {
    private final AdapterContext adapterContext;
    private final DataTreeChangeListener<T> listener;
    private final LogicalDatastoreType store;
    private final Class<T> augment;
    private boolean initialSyncDone;

    BindingDOMDataTreeChangeListenerAdapter(AdapterContext adapterContext, DataTreeChangeListener<T> listener, LogicalDatastoreType store, Class<T> augment) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.listener = Objects.requireNonNull(listener);
        this.store = Objects.requireNonNull(store);
        this.augment = augment;
    }

    public void onDataTreeChanged(List<DataTreeCandidate> domChanges) {
        List<DataTreeModification<T>> changes = LazyDataTreeModification.from(this.adapterContext.currentSerializer(), domChanges, this.store, this.augment);
        if (!changes.isEmpty()) {
            this.listener.onDataTreeChanged(changes);
        } else if (!this.initialSyncDone) {
            this.onInitialData();
        }
    }

    public void onInitialData() {
        this.initialSyncDone = true;
        this.listener.onInitialData();
    }
}

