/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataChangeListener;
import org.opendaylight.mdsal.binding.api.DataListener;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeChangeService;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingClusteredDOMDataTreeChangeListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataChangeListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataTreeChangeListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDataTreeChangeListenerRegistration;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

final class BindingDOMDataTreeChangeServiceAdapter
extends AbstractBindingAdapter<DOMDataTreeChangeService>
implements DataTreeChangeService {
    BindingDOMDataTreeChangeServiceAdapter(AdapterContext adapterContext, DOMDataTreeChangeService dataTreeChangeService) {
        super(adapterContext, dataTreeChangeService);
    }

    public <T extends DataObject, L extends DataTreeChangeListener<T>> ListenerRegistration<L> registerDataTreeChangeListener(DataTreeIdentifier<T> treeId, L listener) {
        DOMDataTreeIdentifier domIdentifier = this.toDomTreeIdentifier(treeId);
        LogicalDatastoreType storeType = treeId.getDatastoreType();
        Class target = treeId.getRootIdentifier().getTargetType();
        Class augment = Augmentation.class.isAssignableFrom(target) ? target : null;
        BindingDOMDataTreeChangeListenerAdapter domListener = listener instanceof ClusteredDataTreeChangeListener ? new BindingClusteredDOMDataTreeChangeListenerAdapter(this.adapterContext(), (ClusteredDataTreeChangeListener)listener, storeType, augment) : new BindingDOMDataTreeChangeListenerAdapter(this.adapterContext(), listener, storeType, augment);
        ListenerRegistration domReg = ((DOMDataTreeChangeService)this.getDelegate()).registerDataTreeChangeListener(domIdentifier, domListener);
        return new BindingDataTreeChangeListenerRegistration<L>(listener, domReg);
    }

    public <T extends DataObject> Registration registerDataListener(DataTreeIdentifier<T> treeId, DataListener<T> listener) {
        return ((DOMDataTreeChangeService)this.getDelegate()).registerDataTreeChangeListener(this.toDomTreeInstance(treeId), new BindingDOMDataListenerAdapter<T>(this.adapterContext(), listener));
    }

    public <T extends DataObject> Registration registerDataChangeListener(DataTreeIdentifier<T> treeId, DataChangeListener<T> listener) {
        return ((DOMDataTreeChangeService)this.getDelegate()).registerDataTreeChangeListener(this.toDomTreeInstance(treeId), new BindingDOMDataChangeListenerAdapter<T>(this.adapterContext(), listener));
    }

    private @NonNull DOMDataTreeIdentifier toDomTreeIdentifier(DataTreeIdentifier<?> treeId) {
        return new DOMDataTreeIdentifier(treeId.getDatastoreType(), this.currentSerializer().toYangInstanceIdentifier(treeId.getRootIdentifier()));
    }

    private @NonNull DOMDataTreeIdentifier toDomTreeInstance(DataTreeIdentifier<?> treeId) {
        InstanceIdentifier instanceIdentifier = treeId.getRootIdentifier();
        if (instanceIdentifier.isWildcarded()) {
            throw new IllegalArgumentException("Cannot register listener for wildcard " + instanceIdentifier);
        }
        return this.toDomTreeIdentifier(treeId);
    }
}

