/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractDOMNotificationListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.NotificationListenerInvoker;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

final class BindingDOMNotificationListenerAdapter
extends AbstractDOMNotificationListenerAdapter {
    private final ImmutableMap<SchemaNodeIdentifier.Absolute, NotificationListenerInvoker> invokers;
    private final @NonNull NotificationListener delegate;

    BindingDOMNotificationListenerAdapter(AdapterContext adapterContext, NotificationListener delegate) {
        super(adapterContext);
        this.delegate = Objects.requireNonNull(delegate);
        this.invokers = BindingDOMNotificationListenerAdapter.createInvokerMapFor(delegate.getClass());
    }

    @Override
    void onNotification(SchemaNodeIdentifier.Absolute domType, Notification<?> notification) {
        ((NotificationListenerInvoker)this.invokers.get((Object)domType)).invokeNotification(this.delegate, domType.lastNodeIdentifier(), (DataContainer)notification);
    }

    @Override
    Set<SchemaNodeIdentifier.Absolute> getSupportedNotifications() {
        return this.invokers.keySet();
    }

    private static ImmutableMap<SchemaNodeIdentifier.Absolute, NotificationListenerInvoker> createInvokerMapFor(Class<? extends NotificationListener> implClz) {
        HashMap<SchemaNodeIdentifier.Absolute, NotificationListenerInvoker> builder = new HashMap<SchemaNodeIdentifier.Absolute, NotificationListenerInvoker>();
        for (TypeToken ifaceToken : TypeToken.of(implClz).getTypes().interfaces()) {
            Class iface = ifaceToken.getRawType();
            if (!NotificationListener.class.isAssignableFrom(iface) || !BindingReflections.isBindingClass((Class)iface)) continue;
            Class listenerType = iface;
            NotificationListenerInvoker invoker = NotificationListenerInvoker.from(listenerType);
            for (SchemaNodeIdentifier.Absolute path : BindingDOMNotificationListenerAdapter.getNotificationTypes(listenerType)) {
                builder.put(path, invoker);
            }
        }
        return ImmutableMap.copyOf(builder);
    }

    private static Set<SchemaNodeIdentifier.Absolute> getNotificationTypes(Class<? extends NotificationListener> type) {
        HashSet<SchemaNodeIdentifier.Absolute> ret = new HashSet<SchemaNodeIdentifier.Absolute>();
        for (Method method : type.getMethods()) {
            if (!NotificationListenerInvoker.isNotificationCallback(method)) continue;
            Class<?> notification = method.getParameterTypes()[0];
            ret.add(SchemaNodeIdentifier.Absolute.of((QName)BindingReflections.findQName(notification)));
        }
        return ret;
    }
}

