/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcImplementationAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcAdapterRegistration;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LegacyDOMRpcImplementationAdapter;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.RpcRuntimeType;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@VisibleForTesting
public class BindingDOMRpcProviderServiceAdapter
extends AbstractBindingAdapter<DOMRpcProviderService>
implements RpcProviderService {
    private static final ImmutableSet<YangInstanceIdentifier> GLOBAL = ImmutableSet.of((Object)YangInstanceIdentifier.of());

    public BindingDOMRpcProviderServiceAdapter(AdapterContext adapterContext, DOMRpcProviderService domRpcRegistry) {
        super(adapterContext, domRpcRegistry);
    }

    @Deprecated
    public <R extends RpcService, I extends R> ObjectRegistration<I> registerRpcImplementation(Class<R> type, I implementation) {
        return this.register(this.currentSerializer(), (Class)type, (Object)implementation, (Collection<YangInstanceIdentifier>)GLOBAL);
    }

    @Deprecated
    public <R extends RpcService, I extends R> ObjectRegistration<I> registerRpcImplementation(Class<R> type, I implementation, Set<InstanceIdentifier<?>> paths) {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        return this.register(serializer, type, implementation, BindingDOMRpcProviderServiceAdapter.toYangInstanceIdentifiers(serializer, paths));
    }

    public Registration registerRpcImplementation(Rpc<?, ?> implementation) {
        return this.register(this.currentSerializer(), (Rpc)implementation, (Collection<YangInstanceIdentifier>)GLOBAL);
    }

    public Registration registerRpcImplementation(Rpc<?, ?> implementation, Set<InstanceIdentifier<?>> paths) {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        return this.register(serializer, implementation, BindingDOMRpcProviderServiceAdapter.toYangInstanceIdentifiers(serializer, paths));
    }

    public Registration registerRpcImplementations(ClassToInstanceMap<Rpc<?, ?>> implementations) {
        return this.register(this.currentSerializer(), implementations, (Collection<YangInstanceIdentifier>)GLOBAL);
    }

    public Registration registerRpcImplementations(ClassToInstanceMap<Rpc<?, ?>> implementations, Set<InstanceIdentifier<?>> paths) {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        return this.register(serializer, implementations, BindingDOMRpcProviderServiceAdapter.toYangInstanceIdentifiers(serializer, paths));
    }

    private <T extends Rpc<?, ?>> Registration register(CurrentAdapterSerializer serializer, T implementation, Collection<YangInstanceIdentifier> rpcContextPaths) {
        Class type = implementation.implementedInterface();
        return this.register(serializer, (ClassToInstanceMap<Rpc<?, ?>>)ImmutableClassToInstanceMap.of((Class)type, implementation), rpcContextPaths);
    }

    private Registration register(CurrentAdapterSerializer serializer, ClassToInstanceMap<Rpc<?, ?>> implementations, Collection<YangInstanceIdentifier> rpcContextPaths) {
        BindingRuntimeContext context = serializer.getRuntimeContext();
        return this.register((Map)implementations, rpcContextPaths, (BiFunction)(type, impl) -> {
            RpcRuntimeType def = context.getRpcDefinition(type);
            if (def == null) {
                throw new IllegalArgumentException("Cannot resolve YANG definition of " + type);
            }
            QName rpcName = (QName)def.statement().argument();
            return new Impl(rpcName, new BindingDOMRpcImplementationAdapter(this.adapterContext(), rpcName, (Rpc<?, ?>)impl));
        });
    }

    @Deprecated
    private <S extends RpcService, T extends S> ObjectRegistration<T> register(CurrentAdapterSerializer serializer, Class<S> type, T implementation, Collection<YangInstanceIdentifier> paths) {
        return new BindingRpcAdapterRegistration<T>(implementation, this.register((Map)serializer.getRpcMethods(Objects.requireNonNull(type)), paths, (BiFunction)(rpcName, mh) -> new Impl(Objects.requireNonNull(rpcName), new LegacyDOMRpcImplementationAdapter(this.adapterContext(), (QName)rpcName, mh.bindTo(implementation)))));
    }

    private <K, V> @NonNull Registration register(Map<K, V> map, Collection<YangInstanceIdentifier> paths, BiFunction<K, V, Impl> implFactory) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Impl impl = implFactory.apply(entry.getKey(), entry.getValue());
            paths.forEach(path -> builder.put((Object)DOMRpcIdentifier.create((QName)impl.qname, (YangInstanceIdentifier)path), (Object)impl.impl));
        }
        return ((DOMRpcProviderService)this.getDelegate()).registerRpcImplementations((Map)builder.build());
    }

    private static Collection<YangInstanceIdentifier> toYangInstanceIdentifiers(CurrentAdapterSerializer serializer, Set<InstanceIdentifier<?>> identifiers) {
        ArrayList<YangInstanceIdentifier> ret = new ArrayList<YangInstanceIdentifier>(identifiers.size());
        for (InstanceIdentifier<?> binding : identifiers) {
            ret.add(serializer.toCachedYangInstanceIdentifier(binding));
        }
        return ret;
    }

    private record Impl(@NonNull QName qname, @NonNull DOMRpcImplementation impl) {
    }
}

