/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcFutureAware;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.mdsal.dom.spi.SimpleDOMActionResult;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

final class BindingOperationFluentFuture<O extends RpcOutput>
extends AbstractFuture<DOMActionResult>
implements BindingRpcFutureAware {
    private final ListenableFuture<RpcResult<O>> userFuture;
    private final Class<? extends Action<?, ?, O>> action;
    private final YangInstanceIdentifier.NodeIdentifier identifier;
    private AdapterContext adapterContext;

    BindingOperationFluentFuture(ListenableFuture<RpcResult<O>> userFuture, Class<? extends Action<?, ?, O>> action, YangInstanceIdentifier.NodeIdentifier identifier, AdapterContext adapterContext) {
        this.userFuture = Objects.requireNonNull(userFuture);
        this.action = Objects.requireNonNull(action);
        this.identifier = Objects.requireNonNull(identifier);
        this.adapterContext = Objects.requireNonNull(adapterContext);
        userFuture.addListener(this::userFutureCompleted, MoreExecutors.directExecutor());
    }

    @Override
    public ListenableFuture<RpcResult<?>> getBindingFuture() {
        return this.userFuture;
    }

    private void userFutureCompleted() {
        SimpleDOMActionResult domResult;
        try {
            RpcResult bindingResult = (RpcResult)Futures.getDone(this.userFuture);
            domResult = bindingResult.getResult() != null ? new SimpleDOMActionResult((ContainerNode)this.adapterContext.currentSerializer().toLazyNormalizedNodeActionOutput(this.action, this.identifier, (RpcOutput)bindingResult.getResult()), (Collection)bindingResult.getErrors()) : new SimpleDOMActionResult((Collection)bindingResult.getErrors());
        }
        catch (ExecutionException e) {
            this.adapterContext = null;
            this.setException(e.getCause());
            return;
        }
        catch (Error | RuntimeException e) {
            this.adapterContext = null;
            this.setException(e);
            return;
        }
        this.adapterContext = null;
        this.set(domResult);
    }
}

