/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.InstanceNotificationPublishService;
import org.opendaylight.mdsal.binding.api.InstanceNotificationSpec;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingLoadingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.PublisherAdapter;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMInstanceNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceNotification;

final class InstanceNotificationPublishServiceAdapter
extends AbstractBindingLoadingAdapter<DOMInstanceNotificationPublishService, InstanceNotificationSpec<?, ?>, PublisherAdapter<?, ?>>
implements InstanceNotificationPublishService {
    static final BindingDOMAdapterBuilder.Factory<InstanceNotificationPublishService> BUILDER_FACTORY = Builder::new;

    private InstanceNotificationPublishServiceAdapter(AdapterContext adapterContext, DOMInstanceNotificationPublishService domPublishService) {
        super(adapterContext, domPublishService);
    }

    public <N extends InstanceNotification<N, P>, P extends DataObject> InstanceNotificationPublishService.Publisher<N, P> newPublisher(InstanceNotificationSpec<N, P> notificationSpec) {
        return (InstanceNotificationPublishService.Publisher)this.getAdapter(notificationSpec);
    }

    @Override
    PublisherAdapter<?, ?> loadAdapter(InstanceNotificationSpec<?, ?> key) {
        Class type = key.type();
        Preconditions.checkArgument((boolean)BindingReflections.isBindingClass((Class)type));
        Preconditions.checkArgument((boolean)type.isInterface(), (Object)"Supplied Notification type must be an interface.");
        Preconditions.checkArgument((boolean)InstanceNotification.class.isAssignableFrom(type), (String)"Illegal instance notification class %s", (Object)type);
        return new PublisherAdapter(this.adapterContext(), (DOMInstanceNotificationPublishService)this.getDelegate(), key);
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<InstanceNotificationPublishService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        public Set<Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMInstanceNotificationPublishService.class);
        }

        @Override
        protected InstanceNotificationPublishService createInstance(ClassToInstanceMap<DOMService> delegates) {
            return new InstanceNotificationPublishServiceAdapter(this.adapterContext(), (DOMInstanceNotificationPublishService)delegates.getInstance(DOMInstanceNotificationPublishService.class));
        }
    }
}

