/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractDataObjectModification;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;

final class LazyAugmentationModification<A extends Augmentation<?>>
extends AbstractDataObjectModification<A, BindingAugmentationCodecTreeNode<A>> {
    private final @NonNull ImmutableList<DataTreeCandidateNode> domChildNodes;

    private LazyAugmentationModification(BindingAugmentationCodecTreeNode<A> codec, DataTreeCandidateNode parent, ImmutableList<DataTreeCandidateNode> domChildNodes) {
        super(parent, codec, codec.deserializePathArgument(null));
        this.domChildNodes = Objects.requireNonNull(domChildNodes);
    }

    static <A extends Augmentation<?>> @Nullable LazyAugmentationModification<A> forModifications(BindingAugmentationCodecTreeNode<A> codec, DataTreeCandidateNode parent, Collection<DataTreeCandidateNode> children) {
        ImmutableList domChildren = (ImmutableList)children.stream().filter(childMod -> childMod.modificationType() != ModificationType.UNMODIFIED).collect(ImmutableList.toImmutableList());
        return domChildren.isEmpty() ? null : new LazyAugmentationModification<A>(codec, parent, (ImmutableList<DataTreeCandidateNode>)domChildren);
    }

    static <A extends Augmentation<?>> @Nullable LazyAugmentationModification<A> forParent(BindingAugmentationCodecTreeNode<A> codec, DataTreeCandidateNode parent) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (YangInstanceIdentifier.NodeIdentifier pathArg : codec.childPathArguments()) {
            DataTreeCandidateNode child = parent.modifiedChild((YangInstanceIdentifier.PathArgument)pathArg);
            if (child == null) continue;
            builder.add((Object)child);
        }
        ImmutableList domChildren = builder.build();
        return domChildren.isEmpty() ? null : new LazyAugmentationModification<A>(codec, parent, (ImmutableList<DataTreeCandidateNode>)domChildren);
    }

    ImmutableList<DataTreeCandidateNode> domChildNodes() {
        return this.domChildNodes;
    }

    @Override
    ModificationType domModificationType() {
        Augmentation before = (Augmentation)this.getDataBefore();
        Augmentation after = (Augmentation)this.getDataAfter();
        if (before == null) {
            return after == null ? ModificationType.UNMODIFIED : ModificationType.APPEARED;
        }
        return after == null ? ModificationType.DISAPPEARED : ModificationType.SUBTREE_MODIFIED;
    }

    @Override
    A deserialize(NormalizedNode normalized) {
        return (A)((BindingAugmentationCodecTreeNode)this.codec).filterFrom(normalized);
    }

    @Override
    DataTreeCandidateNode firstModifiedChild(YangInstanceIdentifier.PathArgument arg) {
        return this.domChildNodes.stream().filter(child -> arg.equals((Object)child.name())).findFirst().orElse(null);
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper).add("domType", (Object)this.domData.modificationType()).add("domChildren", this.domChildNodes);
    }
}

