/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractDataObjectModification;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataObjectModification;
import org.opendaylight.mdsal.binding.dom.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

final class LazyDataTreeModification<T extends DataObject>
implements DataTreeModification<T> {
    private final @NonNull DataTreeIdentifier<T> path;
    private final @NonNull DataObjectModification<T> rootNode;

    private LazyDataTreeModification(DataTreeIdentifier<T> path, DataObjectModification<T> modification) {
        this.path = Objects.requireNonNull(path);
        this.rootNode = Objects.requireNonNull(modification);
    }

    static <T extends DataObject> @Nullable DataTreeModification<T> from(CurrentAdapterSerializer serializer, DataTreeCandidate domChange, LogicalDatastoreType datastoreType, Class<T> augment) {
        InstanceIdentifier<T> bindingPath = LazyDataTreeModification.createBindingPath(serializer, domChange.getRootPath(), augment);
        CommonDataObjectCodecTreeNode codec = serializer.getSubtreeCodec(bindingPath);
        AbstractDataObjectModification<?, ?> modification = LazyDataObjectModification.from(codec, domChange.getRootNode());
        return modification == null ? null : new LazyDataTreeModification<T>(DataTreeIdentifier.create((LogicalDatastoreType)datastoreType, bindingPath), modification);
    }

    static <T extends DataObject> @Nullable DataTreeModification<T> from(CurrentAdapterSerializer serializer, DOMDataTreeCandidate candidate, Class<T> augment) {
        DOMDataTreeIdentifier domRootPath = candidate.getRootPath();
        InstanceIdentifier<T> bindingPath = LazyDataTreeModification.createBindingPath(serializer, domRootPath.getRootIdentifier(), augment);
        CommonDataObjectCodecTreeNode codec = serializer.getSubtreeCodec(bindingPath);
        AbstractDataObjectModification<?, ?> modification = LazyDataObjectModification.from(codec, candidate.getRootNode());
        return modification == null ? null : new LazyDataTreeModification<T>(DataTreeIdentifier.create((LogicalDatastoreType)domRootPath.getDatastoreType(), bindingPath), modification);
    }

    static <T extends DataObject> @NonNull List<DataTreeModification<T>> from(CurrentAdapterSerializer codec, List<DataTreeCandidate> domChanges, LogicalDatastoreType datastoreType, Class<T> augment) {
        ArrayList<DataTreeModification<T>> result = new ArrayList<DataTreeModification<T>>(domChanges.size());
        for (DataTreeCandidate domChange : domChanges) {
            DataTreeModification<T> bindingChange = LazyDataTreeModification.from(codec, domChange, datastoreType, augment);
            if (bindingChange == null) continue;
            result.add(bindingChange);
        }
        return result;
    }

    private static @NonNull InstanceIdentifier<?> createBindingPath(CurrentAdapterSerializer serializer, YangInstanceIdentifier domPath, Class<?> augment) {
        InstanceIdentifier bindingPath = serializer.coerceInstanceIdentifier(domPath);
        return augment == null ? bindingPath : bindingPath.augmentation(augment.asSubclass(Augmentation.class));
    }

    public DataObjectModification<T> getRootNode() {
        return this.rootNode;
    }

    public DataTreeIdentifier<T> getRootPath() {
        return this.path;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", this.path).add("rootNode", this.rootNode).toString();
    }
}

