/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true, service={AdapterContext.class})
public final class OSGiBlockingBindingNormalizer
implements AdapterContext {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiBlockingBindingNormalizer.class);
    @Reference(updated="update")
    volatile BindingDOMCodecServices codec = null;
    private volatile CurrentAdapterSerializer serializer;

    @Override
    public CurrentAdapterSerializer currentSerializer() {
        return (CurrentAdapterSerializer)((Object)Verify.verifyNotNull((Object)((Object)this.serializer)));
    }

    @Activate
    void activate() {
        this.serializer = new CurrentAdapterSerializer(this.codec);
        LOG.info("Binding/DOM adapter activated");
    }

    @Deactivate
    void deactivate() {
        this.serializer = null;
        LOG.info("Binding/DOM adapter deactivated");
    }

    void update() {
        this.serializer = new CurrentAdapterSerializer(this.codec);
        LOG.info("Binding/DOM adapter updated");
    }
}

