/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.lang.reflect.Method;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractRpcAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.RpcInvocationStrategy;
import org.opendaylight.mdsal.binding.runtime.api.RpcRuntimeType;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.binding.RpcInput;

final class RpcAdapter<T extends Rpc<?, ?>>
extends AbstractRpcAdapter {
    private final RpcInvocationStrategy strategy;
    private final Method invokeMethod;

    RpcAdapter(AdapterContext adapterContext, DOMRpcService delegate, Class<T> type) {
        super(adapterContext, delegate, type);
        CurrentAdapterSerializer serializer = adapterContext.currentSerializer();
        RpcRuntimeType rpcType = serializer.getRuntimeContext().getRpcDefinition(type);
        if (rpcType == null) {
            throw new IllegalStateException("Failed to find runtime type for " + type);
        }
        try {
            this.invokeMethod = type.getMethod("invoke", RpcInput.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to find invoke method in " + type, e);
        }
        this.strategy = this.createStrategy(serializer, rpcType);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invokeMethod.equals(method) ? this.strategy.invoke((RpcInput)Objects.requireNonNull(args[0])) : this.defaultInvoke(proxy, method, args);
    }
}

