/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.osgi;

import com.google.common.base.Verify;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAdaptedService<B extends BindingService> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAdaptedService.class);
    static final @NonNull String DELEGATE = "org.opendaylight.mdsal.binding.dom.adapter.osgi.AbstractAdaptedService.DELEGATE";
    private final Class<B> bindingService;
    private @Nullable B delegate;

    AbstractAdaptedService(Class<B> bindingService) {
        this.bindingService = Objects.requireNonNull(bindingService);
    }

    final void start(Map<String, ?> properties) {
        this.delegate = (BindingService)this.bindingService.cast(Verify.verifyNotNull(properties.get(DELEGATE)));
        LOG.info("Binding/DOM adapter for {} activated", (Object)this.bindingService.getSimpleName());
    }

    final void stop(int reason) {
        this.delegate = null;
        LOG.info("Binding/DOM adapter for {} deactivated (reason {})", (Object)this.bindingService.getSimpleName(), (Object)reason);
    }

    final @NonNull B delegate() {
        return (B)((BindingService)Verify.verifyNotNull(this.delegate));
    }
}

