/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.query.ComparableMatchBuilder;
import org.opendaylight.mdsal.binding.api.query.MatchBuilderPath;
import org.opendaylight.mdsal.binding.api.query.StringMatchBuilder;
import org.opendaylight.mdsal.binding.api.query.ValueMatchBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultComparableMatchBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultStringMatchBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultValueMatchBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.query.QueryBuilderState;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

final class DefaultMatchBuilderPath<O extends DataObject, T extends DataObject>
implements MatchBuilderPath<O, T> {
    private final QueryBuilderState builder;
    private final InstanceIdentifier<O> select;
    private final InstanceIdentifier.Builder<T> target;

    DefaultMatchBuilderPath(QueryBuilderState builder, InstanceIdentifier<O> select, InstanceIdentifier.Builder<T> target) {
        this.builder = Objects.requireNonNull(builder);
        this.select = Objects.requireNonNull(select);
        this.target = Objects.requireNonNull(target);
    }

    public <N extends ChildOf<? super T>> MatchBuilderPath<O, N> childObject(Class<N> childClass) {
        this.target.child(childClass);
        return this;
    }

    public <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> MatchBuilderPath<O, N> extractChild(Class<C> caseClass, Class<N> childClass) {
        this.target.child(caseClass, childClass);
        return this;
    }

    public <N extends KeyAware<K> & ChildOf<? super T>, K extends Key<N>> MatchBuilderPath<O, N> extractChild(Class<@NonNull N> listItem, K listKey) {
        this.target.child(listItem, listKey);
        return this;
    }

    public ValueMatchBuilder<O, Boolean> leaf(MatchBuilderPath.BooleanLeafReference<T> methodRef) {
        return this.defaultFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public ComparableMatchBuilder<O, Decimal64> leaf(MatchBuilderPath.Decimal64LeafReference<T> methodRef) {
        return this.comparableFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public ValueMatchBuilder<O, Empty> leaf(MatchBuilderPath.EmptyLeafReference<T> methodRef) {
        return this.defaultFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public StringMatchBuilder<O> leaf(MatchBuilderPath.StringLeafReference<T> methodRef) {
        return new DefaultStringMatchBuilder<O>(this.builder, this.select, this.builder.bindMethod((InstanceIdentifier<?>)this.target.build(), (MatchBuilderPath.LeafReference<?, ?>)methodRef));
    }

    public ComparableMatchBuilder<O, Byte> leaf(MatchBuilderPath.Int8LeafReference<T> methodRef) {
        return this.comparableFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public ComparableMatchBuilder<O, Short> leaf(MatchBuilderPath.Int16LeafReference<T> methodRef) {
        return this.comparableFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public ComparableMatchBuilder<O, Integer> leaf(MatchBuilderPath.Int32LeafReference<T> methodRef) {
        return this.comparableFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public ComparableMatchBuilder<O, Long> leaf(MatchBuilderPath.Int64LeafReference<T> methodRef) {
        return this.comparableFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public ComparableMatchBuilder<O, Uint8> leaf(MatchBuilderPath.Uint8LeafReference<T> methodRef) {
        return this.comparableFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public ComparableMatchBuilder<O, Uint16> leaf(MatchBuilderPath.Uint16LeafReference<T> methodRef) {
        return this.comparableFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public ComparableMatchBuilder<O, Uint32> leaf(MatchBuilderPath.Uint32LeafReference<T> methodRef) {
        return this.comparableFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public ComparableMatchBuilder<O, Uint64> leaf(MatchBuilderPath.Uint64LeafReference<T> methodRef) {
        return this.comparableFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public <I extends BaseIdentity> ValueMatchBuilder<O, I> leaf(MatchBuilderPath.IdentityLeafReference<T, I> methodRef) {
        return this.defaultFor((MatchBuilderPath.LeafReference)methodRef);
    }

    public <C extends TypeObject> ValueMatchBuilder<O, C> leaf(MatchBuilderPath.TypeObjectLeafReference<T, C> methodRef) {
        return this.defaultFor((MatchBuilderPath.LeafReference)methodRef);
    }

    private <F> @NonNull ValueMatchBuilder<O, F> defaultFor(MatchBuilderPath.LeafReference<T, F> ref) {
        return new DefaultValueMatchBuilder(this.builder, this.select, this.builder.bindMethod(this.target.build(), ref));
    }

    private <F extends Comparable<F>> @NonNull ComparableMatchBuilder<O, F> comparableFor(MatchBuilderPath.LeafReference<T, F> ref) {
        return new DefaultComparableMatchBuilder(this.builder, this.select, this.builder.bindMethod(this.target.build(), ref));
    }
}

