/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.api.query.QueryResult;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQueryResult;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.dom.api.query.DOMQuery;
import org.opendaylight.mdsal.dom.api.query.DOMQueryLike;
import org.opendaylight.mdsal.dom.api.query.DOMQueryResult;
import org.opendaylight.yangtools.yang.binding.DataObject;

@Beta
@NonNullByDefault
public final class DefaultQuery<T extends DataObject>
implements QueryExpression<T>,
DOMQueryLike {
    private final BindingCodecTree codec;
    private final DOMQuery domQuery;

    DefaultQuery(BindingCodecTree codec, DOMQuery domQuery) {
        this.codec = Objects.requireNonNull(codec);
        this.domQuery = Objects.requireNonNull(domQuery);
    }

    public DOMQuery asDOMQuery() {
        return this.domQuery;
    }

    public QueryResult<T> toQueryResult(DOMQueryResult domResult) {
        return new DefaultQueryResult(this.codec, domResult);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dom", (Object)this.domQuery).toString();
    }
}

