/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.query.QueryExecutor;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.api.query.QueryResult;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQuery;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.dom.api.query.DOMQuery;
import org.opendaylight.mdsal.dom.spi.query.DOMQueryEvaluator;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

@Beta
public final class SimpleQueryExecutor
implements QueryExecutor {
    private final NormalizedNode root;

    public SimpleQueryExecutor(NormalizedNode root) {
        this.root = Objects.requireNonNull(root);
    }

    public <T extends DataObject> QueryResult<T> executeQuery(QueryExpression<T> query) {
        Preconditions.checkArgument((boolean)(query instanceof DefaultQuery), (String)"Unsupported expression %s", query);
        DefaultQuery defaultQuery = (DefaultQuery)query;
        return defaultQuery.toQueryResult(DOMQueryEvaluator.evaluateOnRoot((DOMQuery)defaultQuery.asDOMQuery(), (NormalizedNode)this.root));
    }

    public static @NonNull Builder builder(BindingCodecTree codec) {
        return new Builder(codec);
    }

    public static final class Builder {
        private final DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> rootBuilder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(SchemaContext.NAME));
        private final BindingCodecTree codec;

        Builder(BindingCodecTree codec) {
            this.codec = Objects.requireNonNull(codec);
        }

        public <T extends ChildOf<? extends DataRoot>> @NonNull Builder add(@NonNull T data) {
            BindingDataObjectCodecTreeNode dataCodec = (BindingDataObjectCodecTreeNode)this.codec.getSubtreeCodec(InstanceIdentifier.create((Class)data.implementedInterface()));
            this.rootBuilder.withChild((DataContainerChild)((BindingDataObjectCodecTreeNode)Verify.verifyNotNull((Object)dataCodec)).serialize(data));
            return this;
        }

        public @NonNull SimpleQueryExecutor build() {
            return new SimpleQueryExecutor(this.rootBuilder.build());
        }
    }
}

