/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.persistence.RecoveryCompleted;
import akka.persistence.SnapshotOffer;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.InitialClientActorContext;
import org.opendaylight.controller.cluster.access.client.SavingClientActorBehavior;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RecoveringClientActorBehavior
extends AbstractClientActorBehavior<InitialClientActorContext> {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveringClientActorBehavior.class);
    private static final String GENERATION_OVERRIDE_PROP_BASE = "org.opendaylight.controller.cluster.access.client.initial.generation.";
    private final FrontendIdentifier currentFrontend;
    private ClientIdentifier lastId = null;

    RecoveringClientActorBehavior(InitialClientActorContext context, FrontendIdentifier frontendId) {
        super(context);
        this.currentFrontend = Objects.requireNonNull(frontendId);
    }

    @Override
    AbstractClientActorBehavior<?> onReceiveCommand(Object command) {
        throw new IllegalStateException("Frontend is recovering");
    }

    @Override
    AbstractClientActorBehavior<?> onReceiveRecover(Object recover) {
        if (recover instanceof RecoveryCompleted) {
            ClientIdentifier nextId;
            if (this.lastId != null) {
                if (!this.currentFrontend.equals((Object)this.lastId.getFrontendId())) {
                    LOG.error("{}: Mismatched frontend identifier, shutting down. Current: {} Saved: {}", new Object[]{this.persistenceId(), this.currentFrontend, this.lastId.getFrontendId()});
                    return null;
                }
                nextId = ClientIdentifier.create((FrontendIdentifier)this.currentFrontend, (long)(this.lastId.getGeneration() + 1L));
            } else {
                nextId = ClientIdentifier.create((FrontendIdentifier)this.currentFrontend, (long)this.initialGeneration());
            }
            LOG.debug("{}: persisting new identifier {}", (Object)this.persistenceId(), (Object)nextId);
            ((InitialClientActorContext)this.context()).saveSnapshot(nextId);
            return new SavingClientActorBehavior((InitialClientActorContext)this.context(), nextId);
        }
        if (recover instanceof SnapshotOffer) {
            SnapshotOffer snapshotOffer = (SnapshotOffer)recover;
            this.lastId = (ClientIdentifier)snapshotOffer.snapshot();
            LOG.debug("{}: recovered identifier {}", (Object)this.persistenceId(), (Object)this.lastId);
        } else {
            LOG.warn("{}: ignoring recovery message {}", (Object)this.persistenceId(), recover);
        }
        return this;
    }

    private long initialGeneration() {
        long ret;
        String propName = GENERATION_OVERRIDE_PROP_BASE + this.currentFrontend.getClientType().getName();
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            LOG.debug("{}: no initial generation override, starting from 0", (Object)this.persistenceId());
            return 0L;
        }
        try {
            ret = Long.parseUnsignedLong(propValue);
        }
        catch (NumberFormatException e) {
            LOG.warn("{}: failed to parse initial generation override '{}', starting from 0", new Object[]{this.persistenceId(), propValue, e});
            return 0L;
        }
        LOG.info("{}: initial generation set to {}", (Object)this.persistenceId(), (Object)ret);
        return ret;
    }
}

