/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public class SourceException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Interface-specified member")
    private final @NonNull StatementSourceReference sourceRef;

    public SourceException(@NonNull String message, @NonNull StatementSourceReference source) {
        super(SourceException.createMessage(message, source));
        this.sourceRef = source;
    }

    public SourceException(@NonNull String message, @NonNull StatementSourceReference source, Throwable cause) {
        super(SourceException.createMessage(message, source), cause);
        this.sourceRef = source;
    }

    public SourceException(@NonNull StatementSourceReference source, @NonNull String format, Object ... args) {
        this(String.format(format, args), source);
    }

    public SourceException(@NonNull StatementSourceReference source, Throwable cause, @NonNull String format, Object ... args) {
        this(String.format(format, args), source, cause);
    }

    public SourceException(@NonNull String message, @NonNull CommonStmtCtx stmt) {
        this(message, stmt.sourceReference());
    }

    public SourceException(@NonNull String message, @NonNull CommonStmtCtx stmt, Throwable cause) {
        this(message, stmt.sourceReference(), cause);
    }

    public SourceException(@NonNull CommonStmtCtx stmt, @NonNull String format, Object ... args) {
        this(stmt.sourceReference(), format, args);
    }

    public SourceException(@NonNull CommonStmtCtx stmt, Throwable cause, @NonNull String format, Object ... args) {
        this(stmt.sourceReference(), cause, format, args);
    }

    public @NonNull StatementSourceReference getSourceReference() {
        return this.sourceRef;
    }

    public static void throwIf(boolean expression, @NonNull CommonStmtCtx stmt, @NonNull String format, Object ... args) {
        if (expression) {
            throw new SourceException(stmt, format, args);
        }
    }

    public static void throwIf(boolean expression, @NonNull StatementSourceReference source, @NonNull String format, Object ... args) {
        if (expression) {
            throw new SourceException(source, format, args);
        }
    }

    public static <T> @NonNull T throwIfNull(@Nullable T obj, @NonNull StatementSourceReference source, @NonNull String format, Object ... args) {
        if (obj == null) {
            throw new SourceException(source, format, args);
        }
        return obj;
    }

    public static <T> @NonNull T throwIfNull(@Nullable T obj, @NonNull CommonStmtCtx stmt, @NonNull String format, Object ... args) {
        if (obj == null) {
            throw new SourceException(stmt.sourceReference(), format, args);
        }
        return obj;
    }

    public static <T> @NonNull T unwrap(Optional<T> opt, @NonNull StatementSourceReference source, @NonNull String format, Object ... args) {
        SourceException.throwIf(opt.isEmpty(), source, format, args);
        return opt.orElseThrow();
    }

    public static <T> @NonNull T unwrap(Optional<T> opt, @NonNull CommonStmtCtx stmt, @NonNull String format, Object ... args) {
        SourceException.throwIf(opt.isEmpty(), stmt, format, args);
        return opt.orElseThrow();
    }

    private static String createMessage(@NonNull String message, @NonNull StatementSourceReference source) {
        return Objects.requireNonNull(message) + " [at " + Objects.requireNonNull(source) + "]";
    }
}

