/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.codec.InstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.util.AbstractNamespaceCodec;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContext;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.data.util.XpathStringParsingPathArgumentBuilder;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;

@Beta
public abstract class AbstractStringInstanceIdentifierCodec
extends AbstractNamespaceCodec<YangInstanceIdentifier>
implements InstanceIdentifierCodec<String> {
    private static final Escaper DQUOT_ESCAPER = Escapers.builder().addEscape('\n', "\\n").addEscape('\t', "\\t").addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();

    protected final String serializeImpl(YangInstanceIdentifier data) {
        StringBuilder sb = new StringBuilder();
        DataSchemaContext.Composite current = this.getDataContextTree().getRoot();
        QNameModule lastModule = null;
        for (YangInstanceIdentifier.PathArgument arg : data.getPathArguments()) {
            DataSchemaContext dataSchemaContext;
            if (current instanceof DataSchemaContext.Composite) {
                DataSchemaContext.Composite composite = current;
                dataSchemaContext = composite.childByArg(arg);
            } else {
                dataSchemaContext = null;
            }
            current = dataSchemaContext;
            Preconditions.checkArgument((current != null ? 1 : 0) != 0, (String)"Invalid input %s: schema for argument %s (after %s) not found", (Object)data, (Object)arg, (Object)sb);
            if (current instanceof DataSchemaContext.PathMixin) continue;
            QName qname = arg.getNodeType();
            sb.append('/');
            this.appendQName(sb, qname, lastModule);
            lastModule = qname.getModule();
            if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
                for (Map.Entry entry : nip.entrySet()) {
                    QName keyName = (QName)entry.getKey();
                    this.appendQName(sb.append('['), keyName, lastModule).append('=');
                    this.appendValue(sb, keyName.getModule(), entry.getValue()).append(']');
                }
                continue;
            }
            if (!(arg instanceof YangInstanceIdentifier.NodeWithValue)) continue;
            YangInstanceIdentifier.NodeWithValue val = (YangInstanceIdentifier.NodeWithValue)arg;
            this.appendValue(sb.append("[.="), lastModule, val.getValue()).append(']');
        }
        return sb.toString();
    }

    private StringBuilder appendValue(StringBuilder sb, QNameModule currentModule, Object value) {
        String string;
        if (value instanceof QName) {
            QName qname = (QName)value;
            return this.appendQName(sb.append('\''), qname, currentModule).append('\'');
        }
        if (value instanceof Set) {
            Set bits = (Set)value;
            sb.append('\'');
            Iterator it = bits.iterator();
            if (it.hasNext()) {
                sb.append(AbstractStringInstanceIdentifierCodec.checkBitsItem(it.next()));
                while (it.hasNext()) {
                    sb.append(' ').append(AbstractStringInstanceIdentifierCodec.checkBitsItem(it.next()));
                }
            }
            return sb.append('\'');
        }
        if (value instanceof YangInstanceIdentifier) {
            YangInstanceIdentifier id = (YangInstanceIdentifier)value;
            string = (String)this.serialize(id);
        } else {
            string = String.valueOf(value);
        }
        String str = string;
        return str.indexOf(39) == -1 ? sb.append('\'').append(str).append('\'') : sb.append('\"').append(DQUOT_ESCAPER.escape(str)).append('\"');
    }

    protected abstract @NonNull DataSchemaContextTree getDataContextTree();

    protected Object deserializeKeyValue(DataSchemaNode schemaNode, LeafrefResolver resolver, String value) {
        return value;
    }

    protected final YangInstanceIdentifier deserializeImpl(String data) {
        return YangInstanceIdentifier.of(new XpathStringParsingPathArgumentBuilder(this, Objects.requireNonNull(data)).build());
    }

    protected QName createQName(@Nullable QNameModule lastModule, String localName) {
        return this.createQName("", localName);
    }

    private static @NonNull String checkBitsItem(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return str;
        }
        throw new IllegalArgumentException("Unexpected bits component " + obj);
    }
}

