/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.impl.context.AbstractContext;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DataSchemaContext {
    public static @NonNull DataSchemaContext of(DataSchemaNode schema) {
        return AbstractContext.of(Objects.requireNonNull(schema));
    }

    public @NonNull DataSchemaNode dataSchemaNode();

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable YangInstanceIdentifier.NodeIdentifier pathStep();

    default public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier getPathStep() {
        YangInstanceIdentifier.NodeIdentifier arg = this.pathStep();
        if (arg != null) {
            return arg;
        }
        throw new UnsupportedOperationException(this + " does not have a fixed path step");
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SimpleValue
    extends DataSchemaContext {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PathMixin
    extends Composite {
        default public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull YangInstanceIdentifier.NodeIdentifier mixinPathStep() {
            return this.getPathStep();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Composite
    extends DataSchemaContext {
        public @Nullable DataSchemaContext childByArg(YangInstanceIdentifier.PathArgument var1);

        public @Nullable DataSchemaContext childByQName(QName var1);

        default public @Nullable DataSchemaContext childByPath(@NonNull YangInstanceIdentifier path) {
            Iterator it = path.getPathArguments().iterator();
            if (!it.hasNext()) {
                return this;
            }
            Composite current = this;
            DataSchemaContext child;
            while ((child = current.childByArg((YangInstanceIdentifier.PathArgument)it.next())) != null && it.hasNext()) {
                if (!(child instanceof Composite)) {
                    return null;
                }
                Composite compositeChild = (Composite)child;
                current = compositeChild;
            }
            return child;
        }

        public @Nullable DataSchemaContext enterChild(SchemaInferenceStack var1, QName var2);

        public @Nullable DataSchemaContext enterChild(SchemaInferenceStack var1, YangInstanceIdentifier.PathArgument var2);
    }
}

