/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.MountPointLabel;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContextFactory;
import org.opendaylight.yangtools.yang.data.util.AbstractMountPointContextFactory;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.spi.AbstractEffectiveModelContextProvider;

final class ImmutableMountPointContext
extends AbstractEffectiveModelContextProvider
implements Immutable,
MountPointContext {
    private final ImmutableMap<MountPointLabel, AbstractMountPointContextFactory.MountPointDefinition> mountPoints;
    private final Function<AbstractMountPointContextFactory.MountPointDefinition, MountPointContextFactory> createFactory;

    ImmutableMountPointContext(EffectiveModelContext modelContext, Iterable<AbstractMountPointContextFactory.MountPointDefinition> mountPoints, Function<AbstractMountPointContextFactory.MountPointDefinition, MountPointContextFactory> createFactory) {
        super(modelContext);
        this.mountPoints = Maps.uniqueIndex(mountPoints, AbstractMountPointContextFactory.MountPointDefinition::label);
        this.createFactory = Objects.requireNonNull(createFactory);
    }

    public Optional<MountPointContextFactory> findMountPoint(MountPointLabel label) {
        AbstractMountPointContextFactory.MountPointDefinition def = (AbstractMountPointContextFactory.MountPointDefinition)this.mountPoints.get((Object)Objects.requireNonNull(label));
        return def == null ? Optional.empty() : Optional.of(this.createFactory.apply(def));
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper).add("mountPoints", this.mountPoints);
    }
}

