/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.function.Function;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

@Beta
public final class QNameCodecUtil {
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').trimResults();

    private QNameCodecUtil() {
    }

    public static QName decodeQName(String str, Function<String, QNameModule> prefixToModule) {
        String identifier;
        String prefix;
        Iterator it = COLON_SPLITTER.split((CharSequence)str).iterator();
        if (it.hasNext()) {
            String first = (String)it.next();
            if (it.hasNext()) {
                prefix = first;
                identifier = (String)it.next();
                Preconditions.checkArgument((!it.hasNext() ? 1 : 0) != 0, (String)"Malformed QName '%s'", (Object)str);
            } else {
                prefix = "";
                identifier = first;
            }
        } else {
            prefix = "";
            identifier = "";
        }
        QNameModule module = prefixToModule.apply(prefix);
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (String)"Cannot resolve prefix '%s' from %s", (Object)prefix, (Object)str);
        return QName.create((QNameModule)module, (String)identifier);
    }

    public static String encodeQName(QName qname, Function<QNameModule, String> moduleToPrefix) {
        String prefix = moduleToPrefix.apply(qname.getModule());
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (String)"Cannot allocated prefix for %s", (Object)qname);
        return prefix.isEmpty() ? qname.getLocalName() : prefix + ":" + qname.getLocalName();
    }
}

