/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Collection;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.DataValidationFailedException;
import org.opendaylight.mdsal.common.api.PostCanCommitStep;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.Cars;
import org.opendaylight.yangtools.concepts.HierarchicalIdentifier;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CarEntryDataTreeCommitCohort
implements DOMDataTreeCommitCohort {
    private static final Logger LOG = LoggerFactory.getLogger(CarEntryDataTreeCommitCohort.class);
    private static final QName YEAR_QNAME = QName.create((QName)Cars.QNAME, (String)"year").intern();
    private static final YangInstanceIdentifier.NodeIdentifier YEAR_NODE_ID = new YangInstanceIdentifier.NodeIdentifier(YEAR_QNAME);

    public FluentFuture<PostCanCommitStep> canCommit(Object txId, EffectiveModelContext ctx, Collection<DOMDataTreeCandidate> candidates) {
        for (DOMDataTreeCandidate candidate : candidates) {
            DataTreeCandidateNode rootNode = candidate.getRootNode();
            NormalizedNode dataAfter = rootNode.dataAfter();
            LOG.info("In canCommit: modificationType: {}, dataBefore: {}, dataAfter: {}", new Object[]{rootNode.modificationType(), rootNode.dataBefore(), dataAfter});
            if (dataAfter == null) continue;
            Verify.verify((boolean)(dataAfter instanceof DataContainerNode), (String)"Expected type DataContainerNode, actual was %s", dataAfter.getClass());
            DataContainerNode entryNode = (DataContainerNode)dataAfter;
            Optional possibleYear = entryNode.findChildByArg((YangInstanceIdentifier.PathArgument)YEAR_NODE_ID);
            if (!possibleYear.isPresent()) continue;
            Number year = (Number)((DataContainerChild)possibleYear.orElseThrow()).body();
            LOG.info("year is {}", (Object)year);
            if (year.longValue() >= 1990L) continue;
            return FluentFutures.immediateFailedFluentFuture((Throwable)new DataValidationFailedException(DOMDataTreeIdentifier.class, (HierarchicalIdentifier)candidate.getRootPath(), String.format("Invalid year %d - year must be >= 1990", year)));
        }
        return PostCanCommitStep.NOOP_SUCCESSFUL_FUTURE;
    }
}

