/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import java.util.HashMap;
import java.util.Map;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.undertow.internal.UndertowFactory;
import org.ops4j.pax.web.service.undertow.internal.UndertowServerController;
import org.osgi.framework.Bundle;
import org.xnio.XnioProvider;

public class UndertowServerControllerFactory
implements ServerControllerFactory {
    private final Bundle paxWebUndertowBundle;
    private final ClassLoader classLoader;
    private final Map<String, ServerController> serverControllers = new HashMap<String, ServerController>();
    private final UndertowFactory undertowFactory;

    public UndertowServerControllerFactory(Bundle paxWebUndertowBundle, ClassLoader classLoader, XnioProvider provider) {
        this.paxWebUndertowBundle = paxWebUndertowBundle;
        this.classLoader = classLoader;
        this.undertowFactory = new UndertowFactory(classLoader, provider);
    }

    public synchronized ServerController createServerController(Configuration configuration) {
        if (this.serverControllers.containsKey(configuration.id())) {
            return this.serverControllers.get(configuration.id());
        }
        UndertowServerController controller = new UndertowServerController(this.paxWebUndertowBundle, this.classLoader, this.undertowFactory, configuration);
        this.serverControllers.put(configuration.id(), controller);
        return controller;
    }

    public void releaseServerController(ServerController controller, Configuration configuration) {
        this.serverControllers.remove(configuration.id(), controller);
    }
}

