/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.akka.segjournal;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.persistence.PersistentRepr;
import akka.serialization.JavaSerializer;
import com.google.common.base.Verify;
import io.atomix.storage.journal.JournalSerdes;
import java.io.IOException;
import java.util.Objects;
import org.opendaylight.controller.akka.segjournal.DataJournalEntry;

final class DataJournalEntrySerializer
implements JournalSerdes.EntrySerdes<DataJournalEntry> {
    private final ExtendedActorSystem actorSystem;

    DataJournalEntrySerializer(ActorSystem actorSystem) {
        this.actorSystem = Objects.requireNonNull((ExtendedActorSystem)actorSystem);
    }

    public void write(JournalSerdes.EntryOutput output, DataJournalEntry entry) throws IOException {
        Verify.verify((boolean)(entry instanceof DataJournalEntry.ToPersistence));
        PersistentRepr repr = ((DataJournalEntry.ToPersistence)entry).repr();
        output.writeString(repr.manifest());
        output.writeString(repr.writerUuid());
        output.writeObject(repr.payload());
    }

    public DataJournalEntry read(JournalSerdes.EntryInput input) throws IOException {
        String manifest = input.readString();
        String uuid = input.readString();
        Object payload = JavaSerializer.currentSystem().withValue(this.actorSystem, () -> ((JournalSerdes.EntryInput)input).readObject());
        return new DataJournalEntry.FromPersistence(manifest, uuid, payload);
    }
}

