/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import org.opendaylight.yangtools.yang.xpath.api.AbstractYangXPathMathSupport;
import org.opendaylight.yangtools.yang.xpath.api.DoubleNumberExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangBooleanConstantExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;

final class DoubleXPathMathSupport
extends AbstractYangXPathMathSupport<DoubleNumberExpr> {
    static final DoubleXPathMathSupport INSTANCE = new DoubleXPathMathSupport();
    private static final long serialVersionUID = 1L;

    private DoubleXPathMathSupport() {
        super(DoubleNumberExpr.class);
    }

    @Override
    public DoubleNumberExpr createNumber(String str) {
        return DoubleNumberExpr.of(Double.parseDouble(str));
    }

    @Override
    public DoubleNumberExpr createNumber(int value) {
        return DoubleNumberExpr.of(value);
    }

    @Override
    protected DoubleNumberExpr doNegateNumber(DoubleNumberExpr number) {
        return DoubleNumberExpr.of(-number.getValue());
    }

    @Override
    protected YangExpr doEvaluate(YangBinaryOperator operator, DoubleNumberExpr left, DoubleNumberExpr right) {
        double l = left.getValue();
        double r = right.getValue();
        return switch (operator) {
            default -> throw new IncompatibleClassChangeError();
            case YangBinaryOperator.DIV -> DoubleNumberExpr.of(l / r);
            case YangBinaryOperator.EQUALS -> YangBooleanConstantExpr.of(left.equals(right));
            case YangBinaryOperator.GT -> YangBooleanConstantExpr.of(l > r);
            case YangBinaryOperator.GTE -> YangBooleanConstantExpr.of(l >= r);
            case YangBinaryOperator.LT -> YangBooleanConstantExpr.of(l < r);
            case YangBinaryOperator.LTE -> YangBooleanConstantExpr.of(l <= r);
            case YangBinaryOperator.MINUS -> DoubleNumberExpr.of(l - r);
            case YangBinaryOperator.MOD -> DoubleNumberExpr.of(l % r);
            case YangBinaryOperator.MUL -> DoubleNumberExpr.of(l * r);
            case YangBinaryOperator.NOT_EQUALS -> YangBooleanConstantExpr.of(!left.equals(right));
            case YangBinaryOperator.PLUS -> DoubleNumberExpr.of(l + r);
        };
    }

    @Override
    protected Object readResolve() {
        return INSTANCE;
    }
}

