/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.jsp;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.jasper.servlet.TldScanner;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class PaxWebTldScanner
extends TldScanner {
    public static final Logger LOG = LoggerFactory.getLogger(PaxWebTldScanner.class);
    private final Bundle bundle;
    private final Set<URL> scanned = new HashSet<URL>();

    public PaxWebTldScanner(ServletContext context, Bundle bundle) {
        super(context, true, true, true);
        this.bundle = bundle;
    }

    @Override
    public void scan() throws IOException, SAXException {
        LOG.info("Searching for TLDs in pax-web-jsp bundle");
        this.scanPlatform();
        LOG.info("Searching for TLDs in context configuration (web.xml)");
        this.scanJspConfig();
        LOG.info("Searching for TLDs in /WEB-INF/");
        this.scanResourcePaths("/WEB-INF/");
        LOG.info("Searching for TLDs in bundle {}", (Object)this.bundle);
        this.scanBundle(this.bundle);
    }

    @Override
    protected void scanPlatform() {
        Bundle paxWebJsp = FrameworkUtil.getBundle(this.getClass());
        LinkedList tlds = new LinkedList();
        if (paxWebJsp != null) {
            if (Utils.isFragment((Bundle)paxWebJsp)) {
                return;
            }
            if (this.bundle.getState() == 2) {
                return;
            }
            Enumeration e = paxWebJsp.findEntries("/META-INF", "*.tld", true);
            while (e.hasMoreElements()) {
                tlds.add(e.nextElement());
            }
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                tlds.addAll(ClassPathUtil.findEntries((ClassLoader)classLoader, (String)"/META-INF", (String)"*.tld", (boolean)true));
            }
            catch (IOException e) {
                LOG.warn("Problem getting TLD descriptors using ClassLoader {}", (Object)classLoader);
            }
        }
        for (URL tld : tlds) {
            try {
                this.parseTld(new TldResourcePath(tld, null));
            }
            catch (IOException | SAXException e) {
                LOG.warn("Problem parsing TLD at {}", (Object)tld);
            }
        }
    }

    private void scanBundle(Bundle bundle) throws IOException {
        ArrayList tldURLs = new ArrayList(16);
        URL[] urls = ClassPathUtil.getClassPathURLs((Bundle)bundle);
        List jarTLDs = ClassPathUtil.findEntries((Bundle)bundle, (URL[])urls, (String)"META-INF", (String)"*.tld", (boolean)true);
        tldURLs.addAll(jarTLDs);
        HashSet<Bundle> processedBundles = new HashSet<Bundle>();
        Bundle paxWebJsp = FrameworkUtil.getBundle(this.getClass());
        if (paxWebJsp != null) {
            processedBundles.add(paxWebJsp);
        }
        LinkedList<Bundle> bundles = new LinkedList<Bundle>();
        bundles.add(bundle);
        while (bundles.size() > 0) {
            Bundle b = (Bundle)bundles.pop();
            if (processedBundles.contains(b)) continue;
            HashSet reachable = new HashSet();
            ClassPathUtil.getBundlesInClassSpace((Bundle)b, reachable);
            for (Bundle rb : reachable) {
                if (Utils.isFragment((Bundle)rb)) continue;
                bundles.add(rb);
            }
            List bundleTLDs = ClassPathUtil.findEntries(Collections.singletonList(b), (String)"META-INF", (String)"*.tld", (boolean)true, (boolean)false);
            tldURLs.addAll(bundleTLDs);
            processedBundles.add(b);
        }
        for (URL tld : tldURLs) {
            try {
                this.parseTld(new TldResourcePath(tld, null));
            }
            catch (IOException | SAXException e) {
                LOG.warn("Problem parsing TLD at {}", (Object)tld);
            }
        }
    }

    @Override
    protected void parseTld(TldResourcePath path) throws IOException, SAXException {
        if (this.scanned.contains(path.getUrl())) {
            return;
        }
        LOG.info("Parsing TLD {}", (Object)path.getUrl());
        super.parseTld(path);
        this.scanned.add(path.getUrl());
    }
}

