/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;

final class SchemalessXMLStreamNormalizedNodeStreamWriter
extends XMLStreamNormalizedNodeStreamWriter<Object> {
    private final Deque<NodeType> nodeTypeStack = new ArrayDeque<NodeType>();

    SchemalessXMLStreamNormalizedNodeStreamWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.nodeTypeStack.push(NodeType.SCALAR);
        this.startElement(name.getNodeType());
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        this.nodeTypeStack.push(NodeType.SCALAR);
        this.startElement(name.getNodeType());
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.nodeTypeStack.push(NodeType.LEAF_SET);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.nodeTypeStack.push(NodeType.LEAF_SET);
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.nodeTypeStack.push(NodeType.CONTAINER);
        this.startElement(name.getNodeType());
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.nodeTypeStack.push(NodeType.CHOICE);
    }

    public boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (DOMSource.class.isAssignableFrom(objectModel)) {
            this.nodeTypeStack.push(NodeType.ANY_XML);
            this.startElement(name.getNodeType());
            return true;
        }
        return false;
    }

    @Override
    String encodeValue(ValueWriter xmlWriter, Object value, Object context) {
        return value.toString();
    }

    @Override
    String encodeAnnotationValue(ValueWriter xmlWriter, QName qname, Object value) {
        return value.toString();
    }

    @Override
    void startList(YangInstanceIdentifier.NodeIdentifier name) {
        this.nodeTypeStack.push(NodeType.LIST);
    }

    @Override
    void startListItem(YangInstanceIdentifier.PathArgument name) throws IOException {
        this.nodeTypeStack.push(NodeType.LIST_ITEM);
        this.startElement(name.getNodeType());
    }

    public void scalarValue(Object value) throws IOException {
        NodeType type = this.nodeTypeStack.peek();
        if (type == NodeType.SCALAR) {
            this.writeValue(value, null);
        } else if (type == NodeType.ANYDATA) {
            this.anydataValue(value);
        } else {
            throw new IllegalStateException("Unexpected scalar " + value + " in type " + type);
        }
    }

    public void domSourceValue(DOMSource value) throws IOException {
        NodeType type = this.nodeTypeStack.peek();
        Preconditions.checkState((type == NodeType.ANY_XML ? 1 : 0) != 0, (String)"Unexpected DOMSource %s in %s", (Object)value, (Object)((Object)type));
        this.anyxmlValue(value);
    }

    public void endNode() throws IOException {
        NodeType type = this.nodeTypeStack.pop();
        switch (type) {
            case CONTAINER: 
            case LIST_ITEM: 
            case SCALAR: 
            case ANY_XML: 
            case ANYDATA: {
                this.endElement();
                break;
            }
        }
    }

    @Override
    void startAnydata(YangInstanceIdentifier.NodeIdentifier name) {
        this.nodeTypeStack.push(NodeType.ANYDATA);
    }

    private static enum NodeType {
        CONTAINER,
        LEAF_SET,
        LIST,
        LIST_ITEM,
        YANG_MODELED_ANY_XML,
        CHOICE,
        AUGMENTATION,
        SCALAR,
        ANY_XML,
        ANYDATA;

    }
}

