/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.runtime.api.ActionRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.IdentityRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RpcRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.binding.YangData;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

@Beta
public abstract class AbstractBindingRuntimeContext
implements BindingRuntimeContext {
    private final LoadingCache<@NonNull QName, @NonNull Class<? extends BaseIdentity>> identityClasses = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<QName, Class<? extends BaseIdentity>>(){

        public Class<? extends BaseIdentity> load(QName key) {
            IdentityRuntimeType type = AbstractBindingRuntimeContext.this.getTypes().findIdentity(key).orElseThrow(() -> new IllegalArgumentException("Supplied QName " + key + " is not a valid identity"));
            try {
                return AbstractBindingRuntimeContext.this.loadClass(type.getIdentifier()).asSubclass(BaseIdentity.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Required class " + type + " was not found.", e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(key + " resolves to a non-identity class", e);
            }
        }
    });

    @Override
    public final <T extends Augmentation<?>> AugmentRuntimeType getAugmentationDefinition(Class<T> augClass) {
        return this.getTypes().findSchema(JavaTypeName.create(augClass)).filter(AugmentRuntimeType.class::isInstance).map(AugmentRuntimeType.class::cast).orElse(null);
    }

    @Override
    public final CompositeRuntimeType getSchemaDefinition(Class<?> cls) {
        Preconditions.checkArgument((!Augmentation.class.isAssignableFrom(cls) ? 1 : 0) != 0, (String)"Supplied class must not be an augmentation (%s is)", cls);
        Preconditions.checkArgument((!Action.class.isAssignableFrom(cls) ? 1 : 0) != 0, (String)"Supplied class must not be an action (%s is)", cls);
        Preconditions.checkArgument((!Notification.class.isAssignableFrom(cls) ? 1 : 0) != 0, (String)"Supplied class must not be a notification (%s is)", cls);
        return this.getTypes().findSchema(JavaTypeName.create(cls)).orElse(null);
    }

    @Override
    public final ActionRuntimeType getActionDefinition(Class<? extends Action<?, ?, ?>> cls) {
        return this.getTypes().findSchema(JavaTypeName.create(cls)).orElse(null);
    }

    @Override
    public final RpcRuntimeType getRpcDefinition(Class<? extends Rpc<?, ?>> cls) {
        return this.getTypes().findSchema(JavaTypeName.create(cls)).orElse(null);
    }

    @Override
    public final RuntimeType getTypeWithSchema(Class<?> type) {
        return this.getTypes().findSchema(JavaTypeName.create(type)).orElseThrow(() -> new IllegalArgumentException("Failed to find schema for " + type));
    }

    @Override
    public final Class<?> getClassForSchema(SchemaNodeIdentifier.Absolute schema) {
        RuntimeType child = this.getTypes().schemaTreeChild(schema);
        Preconditions.checkArgument((child != null ? 1 : 0) != 0, (String)"Failed to find binding type for %s", (Object)schema);
        return this.loadClass(child);
    }

    @Override
    public final Class<? extends BaseIdentity> getIdentityClass(QName input) {
        try {
            return (Class)this.identityClasses.get((Object)Objects.requireNonNull(input));
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new IllegalStateException("Unexpected error looking up " + input, e);
        }
    }

    @Override
    public final Class<? extends RpcInput> getRpcInput(QName rpcName) {
        return this.loadClass(this.getTypes().findRpcInput(rpcName).orElseThrow(() -> new IllegalArgumentException("Failed to find RpcInput for " + rpcName))).asSubclass(RpcInput.class);
    }

    @Override
    public final Class<? extends RpcOutput> getRpcOutput(QName rpcName) {
        return this.loadClass(this.getTypes().findRpcOutput(rpcName).orElseThrow(() -> new IllegalArgumentException("Failed to find RpcOutput for " + rpcName))).asSubclass(RpcOutput.class);
    }

    @Override
    public final Class<? extends YangData<?>> getYangDataClass(YangDataName templateName) {
        return this.loadClass(this.getTypes().findYangData(templateName).orElseThrow(() -> new IllegalArgumentException("Failed to find YangData for " + templateName))).asSubclass(YangData.class);
    }

    private Class<?> loadClass(RuntimeType type) {
        try {
            return this.loadClass(type.javaType());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

