/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.tree.spi.DefaultDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.spi.NormalizedNodeDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.TerminalDataTreeCandidateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class DataTreeCandidates {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeCandidates.class);

    private DataTreeCandidates() {
    }

    public static @NonNull DataTreeCandidate newDataTreeCandidate(YangInstanceIdentifier rootPath, DataTreeCandidateNode rootNode) {
        return new DefaultDataTreeCandidate(rootPath, rootNode);
    }

    public static @NonNull DataTreeCandidate fromNormalizedNode(YangInstanceIdentifier rootPath, NormalizedNode node) {
        return new DefaultDataTreeCandidate(rootPath, new NormalizedNodeDataTreeCandidateNode(node));
    }

    public static void applyToCursor(DataTreeModificationCursor cursor, DataTreeCandidate candidate) {
        DataTreeCandidateNodes.applyToCursor(cursor, candidate.getRootNode());
    }

    public static void applyToModification(DataTreeModification modification, DataTreeCandidate candidate) {
        if (modification instanceof CursorAwareDataTreeModification) {
            DataTreeCandidates.applyToCursorAwareModification((CursorAwareDataTreeModification)modification, candidate);
            return;
        }
        DataTreeCandidateNode node = candidate.getRootNode();
        YangInstanceIdentifier path = candidate.getRootPath();
        switch (node.modificationType()) {
            case DELETE: {
                modification.delete(path);
                LOG.debug("Modification {} deleted path {}", (Object)modification, (Object)path);
                break;
            }
            case SUBTREE_MODIFIED: {
                LOG.debug("Modification {} modified path {}", (Object)modification, (Object)path);
                NodeIterator iterator = new NodeIterator(null, path, node.childNodes().iterator());
                while ((iterator = iterator.next(modification)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                LOG.debug("Modification {} unmodified path {}", (Object)modification, (Object)path);
                break;
            }
            case WRITE: {
                modification.write(path, (NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                LOG.debug("Modification {} written path {}", (Object)modification, (Object)path);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + node.modificationType());
            }
        }
    }

    public static @NonNull DataTreeCandidate aggregate(@NonNull List<? extends DataTreeCandidate> candidates) {
        Iterator<? extends DataTreeCandidate> it = candidates.iterator();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"Input must not be empty");
        DataTreeCandidate first = Objects.requireNonNull(it.next(), "Input must not contain null entries");
        if (!it.hasNext()) {
            return first;
        }
        YangInstanceIdentifier rootPath = first.getRootPath();
        ArrayList<DataTreeCandidateNode> roots = new ArrayList<DataTreeCandidateNode>(candidates.size());
        roots.add(first.getRootNode());
        it.forEachRemaining(candidate -> {
            YangInstanceIdentifier root = candidate.getRootPath();
            Preconditions.checkArgument((boolean)rootPath.equals((Object)root), (String)"Expecting root path %s, encountered %s", (Object)rootPath, (Object)root);
            roots.add(candidate.getRootNode());
        });
        return DataTreeCandidates.newDataTreeCandidate(rootPath, DataTreeCandidates.fastCompressNode((DataTreeCandidateNode)roots.get(0), roots));
    }

    private static DataTreeCandidateNode fastCompressNode(DataTreeCandidateNode first, List<DataTreeCandidateNode> input) {
        DataTreeCandidateNode last = input.get(input.size() - 1);
        ModificationType nodeModification = last.modificationType();
        NormalizedNode dataBefore = first.dataBefore();
        NormalizedNode dataAfter = last.dataAfter();
        switch (nodeModification) {
            case DELETE: {
                ModificationType previous = first.modificationType();
                if (previous == ModificationType.DELETE || previous == ModificationType.DISAPPEARED || previous == ModificationType.UNMODIFIED && dataBefore == null) {
                    DataTreeCandidates.illegalModification(ModificationType.DELETE, ModificationType.DELETE);
                }
                if (dataBefore == null) {
                    return new TerminalDataTreeCandidateNode(null, ModificationType.UNMODIFIED, null, null);
                }
                return new TerminalDataTreeCandidateNode(null, nodeModification, (NormalizedNode)Verify.verifyNotNull((Object)dataBefore), null);
            }
            case WRITE: {
                return new TerminalDataTreeCandidateNode(null, nodeModification, dataBefore, (NormalizedNode)Verify.verifyNotNull((Object)dataAfter));
            }
            case SUBTREE_MODIFIED: 
            case UNMODIFIED: 
            case APPEARED: 
            case DISAPPEARED: {
                return DataTreeCandidates.slowCompressNodes(first, input);
            }
        }
        throw new IllegalStateException("Unsupported modification type " + nodeModification);
    }

    private static DataTreeCandidateNode slowCompressNodes(DataTreeCandidateNode first, List<DataTreeCandidateNode> input) {
        TerminalDataTreeCandidateNode finalNode = new TerminalDataTreeCandidateNode(null, first.dataBefore());
        input.forEach(node -> DataTreeCandidates.compressNode(finalNode, node, null));
        finalNode.setAfter(input.get(input.size() - 1).dataAfter());
        return DataTreeCandidates.cleanUpTree(finalNode);
    }

    private static void compressNode(TerminalDataTreeCandidateNode finalNode, DataTreeCandidateNode node, YangInstanceIdentifier.PathArgument parent) {
        YangInstanceIdentifier.PathArgument identifier;
        try {
            identifier = node.name();
        }
        catch (IllegalStateException e) {
            identifier = null;
        }
        if (finalNode.getNode(identifier).isEmpty()) {
            TerminalDataTreeCandidateNode parentNode = finalNode.getNode(parent).orElseThrow(() -> new IllegalArgumentException("No node found for " + parent + " identifier"));
            TerminalDataTreeCandidateNode childNode = new TerminalDataTreeCandidateNode(identifier, node.dataBefore(), parentNode);
            parentNode.addChildNode(childNode);
        }
        ModificationType nodeModification = node.modificationType();
        switch (nodeModification) {
            case UNMODIFIED: {
                break;
            }
            case DELETE: 
            case SUBTREE_MODIFIED: 
            case WRITE: 
            case APPEARED: 
            case DISAPPEARED: {
                finalNode.setModification(identifier, DataTreeCandidates.compressModifications(finalNode.getModification(identifier), nodeModification, finalNode.dataAfter(identifier) == null));
                finalNode.setData(identifier, node.dataAfter());
                for (DataTreeCandidateNode child : node.childNodes()) {
                    DataTreeCandidates.compressNode(finalNode, child, identifier);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported modification type " + nodeModification);
            }
        }
    }

    private static DataTreeCandidateNode cleanUpTree(TerminalDataTreeCandidateNode finalNode) {
        return DataTreeCandidates.cleanUpTree(finalNode, finalNode);
    }

    private static DataTreeCandidateNode cleanUpTree(TerminalDataTreeCandidateNode finalNode, TerminalDataTreeCandidateNode node) {
        YangInstanceIdentifier.PathArgument identifier = node.name();
        ModificationType nodeModification = node.modificationType();
        Collection<DataTreeCandidateNode> childNodes = node.childNodes();
        for (DataTreeCandidateNode childNode : childNodes) {
            DataTreeCandidates.cleanUpTree(finalNode, (TerminalDataTreeCandidateNode)childNode);
        }
        NormalizedNode dataBefore = finalNode.dataBefore(identifier);
        switch (nodeModification) {
            case UNMODIFIED: {
                finalNode.deleteNode(identifier);
                return finalNode;
            }
            case WRITE: {
                return finalNode;
            }
            case DELETE: {
                if (dataBefore == null) {
                    finalNode.deleteNode(identifier);
                }
                return finalNode;
            }
            case APPEARED: {
                if (dataBefore != null) {
                    DataTreeCandidates.illegalModification(ModificationType.APPEARED, ModificationType.WRITE);
                }
                if (childNodes.isEmpty()) {
                    finalNode.deleteNode(identifier);
                }
                return finalNode;
            }
            case DISAPPEARED: {
                if (dataBefore == null || childNodes.isEmpty()) {
                    finalNode.deleteNode(identifier);
                }
                return finalNode;
            }
            case SUBTREE_MODIFIED: {
                if (dataBefore == null) {
                    DataTreeCandidates.illegalModification(ModificationType.SUBTREE_MODIFIED, ModificationType.DELETE);
                }
                if (childNodes.isEmpty()) {
                    finalNode.deleteNode(identifier);
                }
                return finalNode;
            }
        }
        throw new IllegalStateException("Unsupported modification type " + nodeModification);
    }

    private static ModificationType compressModifications(ModificationType firstModification, ModificationType secondModification, boolean hasNoDataBefore) {
        switch (firstModification) {
            case UNMODIFIED: {
                if (hasNoDataBefore) {
                    return switch (secondModification) {
                        case ModificationType.UNMODIFIED, ModificationType.WRITE, ModificationType.APPEARED -> secondModification;
                        case ModificationType.DELETE -> DataTreeCandidates.illegalModification(ModificationType.DELETE, ModificationType.DELETE);
                        case ModificationType.SUBTREE_MODIFIED -> DataTreeCandidates.illegalModification(ModificationType.SUBTREE_MODIFIED, ModificationType.DELETE);
                        case ModificationType.DISAPPEARED -> DataTreeCandidates.illegalModification(ModificationType.DISAPPEARED, ModificationType.DELETE);
                        default -> throw new IllegalStateException("Unsupported modification type " + secondModification);
                    };
                }
                if (secondModification == ModificationType.APPEARED) {
                    return DataTreeCandidates.illegalModification(ModificationType.APPEARED, ModificationType.WRITE);
                }
                return secondModification;
            }
            case WRITE: {
                return switch (secondModification) {
                    case ModificationType.SUBTREE_MODIFIED, ModificationType.UNMODIFIED, ModificationType.WRITE -> ModificationType.WRITE;
                    case ModificationType.DELETE -> ModificationType.DELETE;
                    case ModificationType.DISAPPEARED -> ModificationType.DISAPPEARED;
                    case ModificationType.APPEARED -> DataTreeCandidates.illegalModification(ModificationType.APPEARED, firstModification);
                    default -> throw new IllegalStateException("Unsupported modification type " + secondModification);
                };
            }
            case DELETE: {
                return switch (secondModification) {
                    case ModificationType.UNMODIFIED -> ModificationType.DELETE;
                    case ModificationType.WRITE, ModificationType.APPEARED -> ModificationType.WRITE;
                    case ModificationType.DELETE -> DataTreeCandidates.illegalModification(ModificationType.DELETE, firstModification);
                    case ModificationType.DISAPPEARED -> DataTreeCandidates.illegalModification(ModificationType.DISAPPEARED, firstModification);
                    case ModificationType.SUBTREE_MODIFIED -> DataTreeCandidates.illegalModification(ModificationType.SUBTREE_MODIFIED, firstModification);
                    default -> throw new IllegalStateException("Unsupported modification type " + secondModification);
                };
            }
            case APPEARED: {
                return switch (secondModification) {
                    case ModificationType.SUBTREE_MODIFIED, ModificationType.UNMODIFIED -> ModificationType.APPEARED;
                    case ModificationType.DELETE, ModificationType.DISAPPEARED -> ModificationType.UNMODIFIED;
                    case ModificationType.WRITE -> ModificationType.WRITE;
                    case ModificationType.APPEARED -> DataTreeCandidates.illegalModification(ModificationType.APPEARED, firstModification);
                    default -> throw new IllegalStateException("Unsupported modification type " + secondModification);
                };
            }
            case DISAPPEARED: {
                return switch (secondModification) {
                    case ModificationType.UNMODIFIED, ModificationType.WRITE -> secondModification;
                    case ModificationType.APPEARED -> ModificationType.SUBTREE_MODIFIED;
                    case ModificationType.DELETE -> DataTreeCandidates.illegalModification(ModificationType.DELETE, firstModification);
                    case ModificationType.DISAPPEARED -> DataTreeCandidates.illegalModification(ModificationType.DISAPPEARED, firstModification);
                    case ModificationType.SUBTREE_MODIFIED -> DataTreeCandidates.illegalModification(ModificationType.SUBTREE_MODIFIED, firstModification);
                    default -> throw new IllegalStateException("Unsupported modification type " + secondModification);
                };
            }
            case SUBTREE_MODIFIED: {
                return switch (secondModification) {
                    case ModificationType.SUBTREE_MODIFIED, ModificationType.UNMODIFIED -> ModificationType.SUBTREE_MODIFIED;
                    case ModificationType.DELETE, ModificationType.WRITE, ModificationType.DISAPPEARED -> secondModification;
                    case ModificationType.APPEARED -> DataTreeCandidates.illegalModification(ModificationType.APPEARED, firstModification);
                    default -> throw new IllegalStateException("Unsupported modification type " + secondModification);
                };
            }
        }
        throw new IllegalStateException("Unsupported modification type " + secondModification);
    }

    private static ModificationType illegalModification(ModificationType first, ModificationType second) {
        throw new IllegalArgumentException(first + " modification event on " + second + " node");
    }

    private static void applyToCursorAwareModification(CursorAwareDataTreeModification modification, DataTreeCandidate candidate) {
        YangInstanceIdentifier candidatePath = candidate.getRootPath();
        YangInstanceIdentifier parent = candidatePath.getParent();
        if (parent == null) {
            try (DataTreeModificationCursor cursor = modification.openCursor();){
                DataTreeCandidateNodes.applyRootToCursor(cursor, candidate.getRootNode());
            }
        }
        try (DataTreeModificationCursor cursor = (DataTreeModificationCursor)modification.openCursor(parent).orElseThrow();){
            DataTreeCandidateNodes.applyRootedNodeToCursor(cursor, candidatePath, candidate.getRootNode());
        }
    }

    private static final class NodeIterator {
        private final Iterator<DataTreeCandidateNode> iterator;
        private final YangInstanceIdentifier path;
        private final NodeIterator parent;

        NodeIterator(@Nullable NodeIterator parent, YangInstanceIdentifier path, Iterator<DataTreeCandidateNode> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
            this.path = Objects.requireNonNull(path);
            this.parent = parent;
        }

        NodeIterator next(DataTreeModification modification) {
            block6: while (this.iterator.hasNext()) {
                DataTreeCandidateNode node = this.iterator.next();
                YangInstanceIdentifier child = this.path.node(node.name());
                switch (node.modificationType()) {
                    case DELETE: {
                        modification.delete(child);
                        LOG.debug("Modification {} deleted path {}", (Object)modification, (Object)child);
                        continue block6;
                    }
                    case SUBTREE_MODIFIED: 
                    case APPEARED: 
                    case DISAPPEARED: {
                        LOG.debug("Modification {} modified path {}", (Object)modification, (Object)child);
                        return new NodeIterator(this, child, node.childNodes().iterator());
                    }
                    case UNMODIFIED: {
                        LOG.debug("Modification {} unmodified path {}", (Object)modification, (Object)child);
                        continue block6;
                    }
                    case WRITE: {
                        modification.write(child, (NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                        LOG.debug("Modification {} written path {}", (Object)modification, (Object)child);
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported modification " + node.modificationType());
            }
            return this.parent;
        }
    }
}

