/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;

@Beta
public class DataTreeConfiguration
implements Immutable {
    public static final DataTreeConfiguration DEFAULT_CONFIGURATION = new Builder(TreeType.CONFIGURATION).setMandatoryNodesValidation(true).build();
    public static final DataTreeConfiguration DEFAULT_OPERATIONAL = new Builder(TreeType.OPERATIONAL).setMandatoryNodesValidation(true).build();
    private final @NonNull TreeType treeType;
    private final @NonNull YangInstanceIdentifier rootPath;
    private final boolean uniqueIndexes;
    private final boolean mandatoryNodesValidation;

    DataTreeConfiguration(TreeType treeType, YangInstanceIdentifier rootPath, boolean uniqueIndexes, boolean mandatoryNodesValidation) {
        this.treeType = Objects.requireNonNull(treeType);
        this.rootPath = Objects.requireNonNull(rootPath);
        this.uniqueIndexes = uniqueIndexes;
        this.mandatoryNodesValidation = mandatoryNodesValidation;
    }

    public @NonNull YangInstanceIdentifier getRootPath() {
        return this.rootPath;
    }

    public @NonNull TreeType getTreeType() {
        return this.treeType;
    }

    public boolean isUniqueIndexEnabled() {
        return this.uniqueIndexes;
    }

    public boolean isMandatoryNodesValidationEnabled() {
        return this.mandatoryNodesValidation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.treeType).add("root", (Object)this.rootPath).add("mandatory", this.mandatoryNodesValidation).add("unique", this.uniqueIndexes).toString();
    }

    public static DataTreeConfiguration getDefault(TreeType treeType) {
        return switch (Objects.requireNonNull(treeType)) {
            default -> throw new IncompatibleClassChangeError();
            case TreeType.CONFIGURATION -> DEFAULT_CONFIGURATION;
            case TreeType.OPERATIONAL -> DEFAULT_OPERATIONAL;
        };
    }

    public static @NonNull Builder builder(TreeType treeType) {
        return new Builder(treeType);
    }

    public @NonNull Builder copyBuilder() {
        return new Builder(this.treeType).setMandatoryNodesValidation(this.isMandatoryNodesValidationEnabled()).setUniqueIndexes(this.isUniqueIndexEnabled()).setRootPath(this.getRootPath());
    }

    public static class Builder
    implements Mutable {
        private final TreeType treeType;
        private YangInstanceIdentifier rootPath;
        private boolean uniqueIndexes;
        private boolean mandatoryNodesValidation;

        public Builder(TreeType treeType) {
            this.treeType = Objects.requireNonNull(treeType);
            this.rootPath = YangInstanceIdentifier.of();
        }

        public @NonNull Builder setUniqueIndexes(boolean uniqueIndexes) {
            this.uniqueIndexes = uniqueIndexes;
            return this;
        }

        public @NonNull Builder setMandatoryNodesValidation(boolean mandatoryNodesValidation) {
            this.mandatoryNodesValidation = mandatoryNodesValidation;
            return this;
        }

        public @NonNull Builder setRootPath(YangInstanceIdentifier rootPath) {
            this.rootPath = rootPath.toOptimized();
            return this;
        }

        public @NonNull DataTreeConfiguration build() {
            return new DataTreeConfiguration(this.treeType, this.rootPath, this.uniqueIndexes, this.mandatoryNodesValidation);
        }
    }
}

