/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.spec.reflect.StringValueObjectFactory;
import org.opendaylight.mdsal.model.ietf.type.util.Ipv4Utils;
import org.opendaylight.mdsal.model.ietf.type.util.Ipv6Utils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.DomainName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;

public final class IetfInetUtil {
    private static final StringValueObjectFactory<Ipv4AddressNoZone> V4NZ_FACTORY = StringValueObjectFactory.create(Ipv4AddressNoZone.class, (String)"0.0.0.0");
    private static final StringValueObjectFactory<Ipv4Prefix> P4_FACTORY = StringValueObjectFactory.create(Ipv4Prefix.class, (String)"0.0.0.0/0");
    private static final StringValueObjectFactory<Ipv6AddressNoZone> V6NZ_FACTORY = StringValueObjectFactory.create(Ipv6AddressNoZone.class, (String)"::0");
    private static final StringValueObjectFactory<Ipv6Prefix> P6_FACTORY = StringValueObjectFactory.create(Ipv6Prefix.class, (String)"::0/0");
    private static final Pattern HOST_IPV4_PATTERN = Pattern.compile("(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?");
    private static final Pattern HOST_IPV6_PATTERN1 = Pattern.compile("((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?");
    private static final Pattern HOST_IPV6_PATTERN2 = Pattern.compile("(([^:]+:){6}(([^:]+:[^:]+)|(.*\\..*)))|((([^:]+:)*[^:]+)?::(([^:]+:)*[^:]+)?)(%.+)?");
    private static final Pattern HOST_DOMAIN_PATTERN = Pattern.compile("((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.");
    private static final Pattern IPADDRESS_IPV4_PATTERN;
    private static final Pattern IPADDRESS_NO_ZONE_IPV4_PATTERN;
    private static final Pattern IPADDRESS_NO_ZONE_IPV6_PATTERN;
    private static final Pattern IPPREFIX_IPV4_PATTERN;

    @Beta
    public static Host hostFor(String str) {
        Matcher ipv4Matcher = HOST_IPV4_PATTERN.matcher(str);
        Matcher ipv6Matcher1 = HOST_IPV6_PATTERN1.matcher(str);
        Matcher ipv6Matcher2 = HOST_IPV6_PATTERN2.matcher(str);
        Matcher domainMatcher = HOST_DOMAIN_PATTERN.matcher(str);
        ArrayList<String> matchers = new ArrayList<String>(3);
        if (ipv6Matcher1.matches() || ipv6Matcher2.matches()) {
            matchers.add(Ipv6Address.class.getSimpleName());
        }
        if (ipv4Matcher.matches()) {
            matchers.add(Ipv4Address.class.getSimpleName());
        } else if (domainMatcher.matches()) {
            matchers.add(DomainName.class.getSimpleName());
        }
        if (matchers.size() > 1) {
            throw new IllegalArgumentException("Cannot create Host from " + str + ". Value is ambigious for " + matchers);
        }
        if (ipv4Matcher.matches()) {
            Ipv4Address ipv4 = new Ipv4Address(str);
            IpAddress ipAddress = new IpAddress(ipv4);
            return new Host(ipAddress);
        }
        if (ipv6Matcher1.matches() || ipv6Matcher2.matches()) {
            Ipv6Address ipv6 = new Ipv6Address(str);
            IpAddress ipAddress = new IpAddress(ipv6);
            return new Host(ipAddress);
        }
        if (domainMatcher.matches()) {
            DomainName domainName = new DomainName(str);
            return new Host(domainName);
        }
        throw new IllegalArgumentException("Cannot create Host from " + str);
    }

    @Beta
    public static IpAddress ipAddressFor(String str) {
        return IPADDRESS_IPV4_PATTERN.matcher(str).matches() ? new IpAddress(new Ipv4Address(str)) : new IpAddress(new Ipv6Address(str));
    }

    @Beta
    public static IpAddressNoZone ipAddressNoZoneFor(String str) {
        if (IPADDRESS_NO_ZONE_IPV4_PATTERN.matcher(str).matches()) {
            return new IpAddressNoZone(new Ipv4AddressNoZone(str));
        }
        if (IPADDRESS_NO_ZONE_IPV6_PATTERN.matcher(str).matches()) {
            return new IpAddressNoZone(new Ipv6AddressNoZone(str));
        }
        throw new IllegalArgumentException("Cannot create IpAddress from " + str);
    }

    @Beta
    public static IpPrefix ipPrefixFor(String defaultValue) {
        return IPPREFIX_IPV4_PATTERN.matcher(defaultValue).matches() ? new IpPrefix(new Ipv4Prefix(defaultValue)) : new IpPrefix(new Ipv6Prefix(defaultValue));
    }

    public static @NonNull IpAddress ipAddressFor(byte @NonNull [] bytes) {
        return switch (bytes.length) {
            case 4 -> new IpAddress(IetfInetUtil.ipv4AddressFor(bytes));
            case 16 -> new IpAddress(IetfInetUtil.ipv6AddressFor(bytes));
            default -> (IpAddress)IetfInetUtil.throwInvalidArray(bytes);
        };
    }

    public static @NonNull IpAddress ipAddressFor(@NonNull InetAddress addr) {
        IetfInetUtil.requireAddress(addr);
        if (addr instanceof Inet4Address) {
            return new IpAddress(IetfInetUtil.ipv4AddressFor(addr));
        }
        if (addr instanceof Inet6Address) {
            return new IpAddress(IetfInetUtil.ipv6AddressFor(addr));
        }
        throw IetfInetUtil.unhandledAddress(addr);
    }

    private static <T> @NonNull T requireAddress(T addr) {
        return Objects.requireNonNull(addr, "Address must not be null");
    }

    public static @NonNull IpAddressNoZone ipAddressNoZoneFor(byte @NonNull [] bytes) {
        return switch (bytes.length) {
            case 4 -> new IpAddressNoZone(IetfInetUtil.ipv4AddressFor(bytes));
            case 16 -> new IpAddressNoZone(IetfInetUtil.ipv6AddressFor(bytes));
            default -> (IpAddressNoZone)IetfInetUtil.throwInvalidArray(bytes);
        };
    }

    public static @NonNull IpAddressNoZone ipAddressNoZoneFor(@NonNull InetAddress addr) {
        IetfInetUtil.requireAddress(addr);
        if (addr instanceof Inet4Address) {
            return new IpAddressNoZone(IetfInetUtil.ipv4AddressFor(addr));
        }
        if (addr instanceof Inet6Address) {
            return new IpAddressNoZone(IetfInetUtil.ipv6AddressFor(addr));
        }
        throw IetfInetUtil.unhandledAddress(addr);
    }

    private static <T> T throwInvalidArray(byte[] bytes) {
        throw new IllegalArgumentException("Invalid array length " + bytes.length);
    }

    private static IllegalArgumentException unhandledAddress(InetAddress addr) {
        return new IllegalArgumentException("Unhandled address " + addr);
    }

    public static @NonNull IpPrefix ipPrefixFor(byte @NonNull [] bytes, int mask) {
        return switch (bytes.length) {
            case 4 -> new IpPrefix(IetfInetUtil.ipv4PrefixFor(bytes, mask));
            case 16 -> new IpPrefix(IetfInetUtil.ipv6PrefixFor(bytes, mask));
            default -> (IpPrefix)IetfInetUtil.throwInvalidArray(bytes);
        };
    }

    public static @NonNull IpPrefix ipPrefixFor(@NonNull InetAddress addr, int mask) {
        IetfInetUtil.requireAddress(addr);
        if (addr instanceof Inet4Address) {
            return new IpPrefix(IetfInetUtil.ipv4PrefixFor(addr, mask));
        }
        if (addr instanceof Inet6Address) {
            return new IpPrefix(IetfInetUtil.ipv6PrefixFor(addr, mask));
        }
        throw IetfInetUtil.unhandledAddress(addr);
    }

    public static @NonNull IpPrefix ipPrefixFor(@NonNull IpAddress addr) {
        Ipv4Address v4 = addr.getIpv4Address();
        return v4 != null ? new IpPrefix(IetfInetUtil.ipv4PrefixFor(v4)) : new IpPrefix(IetfInetUtil.ipv6PrefixFor(IetfInetUtil.coerceIpv6Address(addr)));
    }

    public static @NonNull IpPrefix ipPrefixForNoZone(@NonNull IpAddressNoZone addr) {
        Ipv4AddressNoZone v4 = addr.getIpv4AddressNoZone();
        return v4 != null ? new IpPrefix(IetfInetUtil.ipv4PrefixFor(IetfInetUtil.inet4AddressForNoZone(v4))) : new IpPrefix(IetfInetUtil.ipv6PrefixFor(IetfInetUtil.coerceIpv6AddressNoZone(addr)));
    }

    public static @NonNull InetAddress inetAddressFor(@NonNull IpAddress addr) {
        Ipv4Address v4 = addr.getIpv4Address();
        return v4 != null ? IetfInetUtil.inet4AddressFor(v4) : IetfInetUtil.inet6AddressFor(IetfInetUtil.coerceIpv6Address(addr));
    }

    public static @NonNull InetAddress inetAddressForNoZone(@NonNull IpAddressNoZone addr) {
        Ipv4AddressNoZone v4 = addr.getIpv4AddressNoZone();
        return v4 != null ? IetfInetUtil.inet4AddressForNoZone(v4) : IetfInetUtil.inet6AddressForNoZone(IetfInetUtil.coerceIpv6AddressNoZone(addr));
    }

    public static @NonNull Inet4Address inet4AddressFor(@NonNull Ipv4Address addr) {
        try {
            return (Inet4Address)InetAddress.getByAddress(IetfInetUtil.ipv4AddressBytes(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address " + addr, e);
        }
    }

    public static @NonNull Inet4Address inet4AddressForNoZone(@NonNull Ipv4AddressNoZone addr) {
        try {
            return (Inet4Address)InetAddress.getByAddress(IetfInetUtil.ipv4AddressNoZoneBytes(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address " + addr, e);
        }
    }

    public static @NonNull Inet6Address inet6AddressFor(@NonNull Ipv6Address addr) {
        try {
            return (Inet6Address)InetAddress.getByAddress(IetfInetUtil.ipv6AddressBytes(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address " + addr, e);
        }
    }

    public static @NonNull Inet6Address inet6AddressForNoZone(@NonNull Ipv6AddressNoZone addr) {
        try {
            return (Inet6Address)InetAddress.getByAddress(IetfInetUtil.ipv6AddressNoZoneBytes(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address " + addr, e);
        }
    }

    public static @NonNull Ipv4AddressNoZone ipv4AddressFor(byte @NonNull [] bytes) {
        return (Ipv4AddressNoZone)V4NZ_FACTORY.newInstance(Ipv4Utils.addressString((byte[])bytes));
    }

    public static @NonNull Ipv4AddressNoZone ipv4AddressFor(@NonNull InetAddress addr) {
        return (Ipv4AddressNoZone)V4NZ_FACTORY.newInstance(IetfInetUtil.addressStringV4(addr));
    }

    public static @NonNull Ipv4AddressNoZone ipv4AddressFor(int bits) {
        return (Ipv4AddressNoZone)V4NZ_FACTORY.newInstance(Ipv4Utils.addressString((int)bits));
    }

    public static @NonNull Ipv4AddressNoZone ipv4AddressNoZoneFor(@NonNull Ipv4Address addr) {
        Ipv4AddressNoZone noZone;
        IetfInetUtil.requireAddress(addr);
        return addr instanceof Ipv4AddressNoZone ? (noZone = (Ipv4AddressNoZone)addr) : (Ipv4AddressNoZone)V4NZ_FACTORY.newInstance(IetfInetUtil.stripZone(addr.getValue()));
    }

    public static @NonNull Ipv4AddressNoZone ipv4AddressFrom(@NonNull Ipv4Prefix prefix) {
        return IetfInetUtil.prefixToAddress(V4NZ_FACTORY, prefix.getValue());
    }

    public static byte @NonNull [] ipv4AddressBytes(@NonNull Ipv4Address addr) {
        String str;
        int percent = (str = addr.getValue()).indexOf(37);
        return Ipv4Utils.addressBytes((String)str, (int)(percent == -1 ? str.length() : percent));
    }

    public static int ipv4AddressBits(@NonNull Ipv4Address addr) {
        String str;
        int percent = (str = addr.getValue()).indexOf(37);
        return Ipv4Utils.addressBits((String)str, (int)(percent == -1 ? str.length() : percent));
    }

    public static byte @NonNull [] ipv4AddressNoZoneBytes(@NonNull Ipv4AddressNoZone addr) {
        String str = addr.getValue();
        return Ipv4Utils.addressBytes((String)str, (int)str.length());
    }

    public static int ipv4AddressNoZoneBits(@NonNull Ipv4AddressNoZone addr) {
        String str = addr.getValue();
        return Ipv4Utils.addressBits((String)str, (int)str.length());
    }

    public static @NonNull Ipv4Prefix ipv4PrefixFor(byte @NonNull [] bytes) {
        return (Ipv4Prefix)P4_FACTORY.newInstance(IetfInetUtil.prefixStringV4(bytes));
    }

    public static @NonNull Ipv4Prefix ipv4PrefixFor(byte @NonNull [] address, int mask) {
        return (Ipv4Prefix)P4_FACTORY.newInstance(IetfInetUtil.prefixStringV4(address, mask));
    }

    public static @NonNull Ipv4Prefix ipv4PrefixFor(@NonNull InetAddress addr) {
        return (Ipv4Prefix)P4_FACTORY.newInstance(IetfInetUtil.addressStringV4(addr) + "/32");
    }

    public static @NonNull Ipv4Prefix ipv4PrefixFor(@NonNull InetAddress addr, int mask) {
        return IetfInetUtil.newIpv4Prefix(IetfInetUtil.addressStringV4(addr), mask);
    }

    public static @NonNull Ipv4Prefix ipv4PrefixFor(@NonNull Ipv4Address addr) {
        return (Ipv4Prefix)P4_FACTORY.newInstance(IetfInetUtil.stripZone(addr.getValue()) + "/32");
    }

    public static @NonNull Ipv4Prefix ipv4PrefixFor(@NonNull Ipv4Address addr, int mask) {
        return IetfInetUtil.newIpv4Prefix(IetfInetUtil.stripZone(addr.getValue()), mask);
    }

    public static @NonNull Ipv4Prefix ipv4PrefixForNoZone(@NonNull Ipv4AddressNoZone addr) {
        return (Ipv4Prefix)P4_FACTORY.newInstance(addr.getValue() + "/32");
    }

    public static @NonNull Ipv4Prefix ipv4PrefixForNoZone(@NonNull Ipv4AddressNoZone addr, int mask) {
        return IetfInetUtil.newIpv4Prefix(addr.getValue(), mask);
    }

    public static @NonNull Ipv4Prefix ipv4PrefixForShort(byte @NonNull [] address, int mask) {
        if (mask == 0) {
            return (Ipv4Prefix)P4_FACTORY.getTemplate();
        }
        return IetfInetUtil.v4PrefixForShort(address, 0, mask / 8 + (mask % 8 == 0 ? 0 : 1), mask);
    }

    public static @NonNull Ipv4Prefix ipv4PrefixForShort(byte @NonNull [] array, int startOffset, int mask) {
        if (mask == 0) {
            return (Ipv4Prefix)P4_FACTORY.getTemplate();
        }
        return IetfInetUtil.v4PrefixForShort(array, startOffset, mask / 8 + (mask % 8 == 0 ? 0 : 1), mask);
    }

    private static String stripZone(String str) {
        int percent = str.indexOf(37);
        return percent == -1 ? str : str.substring(0, percent);
    }

    private static @NonNull Ipv4Prefix newIpv4Prefix(String addr, int mask) {
        Preconditions.checkArgument((mask >= 0 && mask <= 32 ? 1 : 0) != 0, (String)"Invalid mask %s", (int)mask);
        return (Ipv4Prefix)P4_FACTORY.newInstance(addr + "/" + mask);
    }

    public static  @NonNull Map.Entry<Ipv4AddressNoZone, Integer> splitIpv4Prefix(@NonNull Ipv4Prefix prefix) {
        return IetfInetUtil.splitPrefix(V4NZ_FACTORY, prefix.getValue());
    }

    public static byte @NonNull [] ipv4PrefixToBytes(@NonNull Ipv4Prefix prefix) {
        String str = prefix.getValue();
        int slash = str.lastIndexOf(47);
        byte[] bytes = new byte[5];
        Ipv4Utils.fillIpv4Bytes((byte[])bytes, (int)0, (String)str, (int)0, (int)slash);
        bytes[4] = (byte)Integer.parseInt(str.substring(slash + 1), 10);
        return bytes;
    }

    public static @NonNull Ipv6AddressNoZone ipv6AddressFor(byte @NonNull [] bytes) {
        return (Ipv6AddressNoZone)V6NZ_FACTORY.newInstance(IetfInetUtil.addressStringV6(bytes));
    }

    public static @NonNull Ipv6AddressNoZone ipv6AddressFor(@NonNull InetAddress addr) {
        return (Ipv6AddressNoZone)V6NZ_FACTORY.newInstance(IetfInetUtil.addressStringV6(addr));
    }

    public static @NonNull Ipv6AddressNoZone ipv6AddressNoZoneFor(@NonNull Ipv6Address addr) {
        Ipv6AddressNoZone noZone;
        IetfInetUtil.requireAddress(addr);
        return addr instanceof Ipv6AddressNoZone ? (noZone = (Ipv6AddressNoZone)addr) : (Ipv6AddressNoZone)V6NZ_FACTORY.newInstance(IetfInetUtil.stripZone(addr.getValue()));
    }

    public static @NonNull Ipv6AddressNoZone ipv6AddressFrom(@NonNull Ipv6Prefix prefix) {
        return IetfInetUtil.prefixToAddress(V6NZ_FACTORY, prefix.getValue());
    }

    public static byte @NonNull [] ipv6AddressBytes(@NonNull Ipv6Address addr) {
        String str;
        int percent = (str = addr.getValue()).indexOf(37);
        return IetfInetUtil.ipv6StringBytes(str, percent == -1 ? str.length() : percent);
    }

    public static byte @NonNull [] ipv6AddressNoZoneBytes(@NonNull Ipv6Address addr) {
        String str = addr.getValue();
        return IetfInetUtil.ipv6StringBytes(str, str.length());
    }

    private static byte @NonNull [] ipv6StringBytes(@NonNull String str, int limit) {
        byte[] bytes = new byte[16];
        Ipv6Utils.fillIpv6Bytes((byte[])bytes, (String)str, (int)limit);
        return bytes;
    }

    public static @NonNull Ipv6Prefix ipv6PrefixFor(byte @NonNull [] bytes) {
        return (Ipv6Prefix)P6_FACTORY.newInstance(IetfInetUtil.addressStringV6(bytes) + "/128");
    }

    public static @NonNull Ipv6Prefix ipv6PrefixFor(byte @NonNull [] address, int mask) {
        Preconditions.checkArgument((mask >= 0 && mask <= 128 ? 1 : 0) != 0, (String)"Invalid mask %s", (int)mask);
        return (Ipv6Prefix)P6_FACTORY.newInstance(IetfInetUtil.addressStringV6(address) + "/" + mask);
    }

    public static @NonNull Ipv6Prefix ipv6PrefixFor(@NonNull InetAddress addr) {
        return (Ipv6Prefix)P6_FACTORY.newInstance(IetfInetUtil.addressStringV6(addr) + "/128");
    }

    public static @NonNull Ipv6Prefix ipv6PrefixFor(@NonNull InetAddress addr, int mask) {
        Preconditions.checkArgument((mask >= 0 && mask <= 128 ? 1 : 0) != 0, (String)"Invalid mask %s", (int)mask);
        return (Ipv6Prefix)P6_FACTORY.newInstance(IetfInetUtil.addressStringV6(addr) + "/" + mask);
    }

    public static @NonNull Ipv6Prefix ipv6PrefixFor(@NonNull Ipv6Address addr) {
        return (Ipv6Prefix)P6_FACTORY.newInstance(IetfInetUtil.stripZone(addr.getValue()) + "/128");
    }

    public static @NonNull Ipv6Prefix ipv6PrefixFor(@NonNull Ipv6Address addr, int mask) {
        return IetfInetUtil.newIpv6Prefix(IetfInetUtil.stripZone(addr.getValue()), mask);
    }

    public static @NonNull Ipv6Prefix ipv6PrefixForNoZone(@NonNull Ipv6AddressNoZone addr) {
        return (Ipv6Prefix)P6_FACTORY.newInstance(addr.getValue() + "/128");
    }

    public static @NonNull Ipv6Prefix ipv6PrefixForNoZone(@NonNull Ipv6AddressNoZone addr, int mask) {
        return IetfInetUtil.newIpv6Prefix(addr.getValue(), mask);
    }

    public static @NonNull Ipv6Prefix ipv6PrefixForShort(byte @NonNull [] address, int mask) {
        return IetfInetUtil.ipv6PrefixForShort(address, 0, mask);
    }

    public static @NonNull Ipv6Prefix ipv6PrefixForShort(byte @NonNull [] array, int startOffset, int mask) {
        if (mask == 0) {
            return (Ipv6Prefix)P6_FACTORY.getTemplate();
        }
        Preconditions.checkArgument((mask > 0 && mask <= 128 ? 1 : 0) != 0, (String)"Invalid mask %s", (int)mask);
        int size = mask / 8 + (mask % 8 == 0 ? 0 : 1);
        byte[] tmp = new byte[16];
        System.arraycopy(array, startOffset, tmp, 0, size);
        return IetfInetUtil.ipv6PrefixFor(tmp, mask);
    }

    private static Ipv6Prefix newIpv6Prefix(String addr, int mask) {
        Preconditions.checkArgument((mask >= 0 && mask <= 128 ? 1 : 0) != 0, (String)"Invalid mask %s", (int)mask);
        return (Ipv6Prefix)P6_FACTORY.newInstance(addr + "/" + mask);
    }

    public static  @NonNull Map.Entry<Ipv6AddressNoZone, Integer> splitIpv6Prefix(@NonNull Ipv6Prefix prefix) {
        return IetfInetUtil.splitPrefix(V6NZ_FACTORY, prefix.getValue());
    }

    private static <T> @NonNull T prefixToAddress(StringValueObjectFactory<T> factory, String str) {
        return (T)factory.newInstance(str.substring(0, str.lastIndexOf(47)));
    }

    private static <T>  @NonNull Map.Entry<T, Integer> splitPrefix(StringValueObjectFactory<T> factory, String str) {
        int slash = str.lastIndexOf(47);
        return new AbstractMap.SimpleImmutableEntry<Object, Integer>(factory.newInstance(str.substring(0, slash)), Integer.valueOf(str.substring(slash + 1)));
    }

    public static byte @NonNull [] ipv6PrefixToBytes(@NonNull Ipv6Prefix prefix) {
        String str = prefix.getValue();
        byte[] bytes = new byte[17];
        int slash = str.lastIndexOf(47);
        Ipv6Utils.fillIpv6Bytes((byte[])bytes, (String)str, (int)slash);
        bytes[16] = (byte)Integer.parseInt(str.substring(slash + 1), 10);
        return bytes;
    }

    private static @NonNull String addressStringV4(InetAddress addr) {
        IetfInetUtil.requireAddress(addr);
        Preconditions.checkArgument((boolean)(addr instanceof Inet4Address), (Object)"Address has to be an Inet4Address");
        return addr.getHostAddress();
    }

    private static String addressStringV6(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length == 16 ? 1 : 0) != 0, (Object)"IPv6 address length is 16 bytes");
        try {
            return IetfInetUtil.addressStringV6(Inet6Address.getByAddress(null, bytes, null));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Invalid input %s", new Object[]{bytes}), e);
        }
    }

    private static String addressStringV6(InetAddress addr) {
        IetfInetUtil.requireAddress(addr);
        Preconditions.checkArgument((boolean)(addr instanceof Inet6Address), (Object)"Address has to be an Inet6Address");
        return IetfInetUtil.addressStringV6((Inet6Address)addr);
    }

    private static String addressStringV6(Inet6Address addr) {
        return InetAddresses.toAddrString((InetAddress)addr);
    }

    private static String prefixStringV4(byte @NonNull [] bytes) {
        StringBuilder sb = new StringBuilder(18);
        Ipv4Utils.appendIpv4String((StringBuilder)sb, (byte[])bytes);
        return sb.append("/32").toString();
    }

    private static String prefixStringV4(byte @NonNull [] bytes, int mask) {
        Preconditions.checkArgument((mask >= 0 && mask <= 32 ? 1 : 0) != 0, (String)"Invalid mask %s", (int)mask);
        StringBuilder sb = new StringBuilder(18);
        Ipv4Utils.appendIpv4String((StringBuilder)sb, (byte[])bytes);
        return sb.append('/').append(mask).toString();
    }

    private static @NonNull Ipv4Prefix v4PrefixForShort(byte @NonNull [] array, int startOffset, int size, int mask) {
        int i;
        if (startOffset == 0 && size == 4 && array.length == 4) {
            return IetfInetUtil.ipv4PrefixFor(array, mask);
        }
        StringBuilder sb = new StringBuilder(18);
        sb.append(Byte.toUnsignedInt(array[startOffset]));
        for (i = 1; i < size; ++i) {
            sb.append('.').append(Byte.toUnsignedInt(array[startOffset + i]));
        }
        for (i = size; i < 4; ++i) {
            sb.append(".0");
        }
        Preconditions.checkArgument((mask > 0 && mask <= 32 ? 1 : 0) != 0, (String)"Invalid mask %s", (int)mask);
        sb.append('/').append(mask);
        return (Ipv4Prefix)P4_FACTORY.newInstance(sb.toString());
    }

    private static @NonNull Ipv6Address coerceIpv6Address(@NonNull IpAddress addr) {
        Ipv6Address ret = addr.getIpv6Address();
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"Address %s is neither IPv4 nor IPv6", (Object)addr);
        return ret;
    }

    private static @NonNull Ipv6AddressNoZone coerceIpv6AddressNoZone(@NonNull IpAddressNoZone addr) {
        Ipv6AddressNoZone ret = addr.getIpv6AddressNoZone();
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"Address %s is neither IPv4 nor IPv6", (Object)addr);
        return ret;
    }

    static {
        Verify.verify((Ipv4Address.PATTERN_CONSTANTS.size() == 1 ? 1 : 0) != 0);
        IPADDRESS_IPV4_PATTERN = Pattern.compile(Ipv4Address.PATTERN_CONSTANTS.get(0));
        IPADDRESS_NO_ZONE_IPV4_PATTERN = Pattern.compile("[0-9\\.]*");
        IPADDRESS_NO_ZONE_IPV6_PATTERN = Pattern.compile("[0-9a-fA-F:\\.]*");
        Verify.verify((Ipv4Prefix.PATTERN_CONSTANTS.size() == 1 ? 1 : 0) != 0);
        IPPREFIX_IPV4_PATTERN = Pattern.compile(Ipv4Prefix.PATTERN_CONSTANTS.get(0));
    }
}

