/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.osgi.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.opendaylight.mdsal.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.runtime.spi.ModuleInfoSnapshotResolver;
import org.opendaylight.mdsal.dom.schema.osgi.impl.OSGiModuleInfoSnapshotImpl;
import org.opendaylight.mdsal.dom.schema.osgi.impl.YangModuleInfoRegistry;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.YangFeatureProvider;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RegularYangModuleInfoRegistry
extends YangModuleInfoRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(RegularYangModuleInfoRegistry.class);
    private final ComponentFactory<OSGiModuleInfoSnapshotImpl> contextFactory;
    private final ModuleInfoSnapshotResolver resolver;
    private @GuardedBy(value={"this"}) ComponentInstance<OSGiModuleInfoSnapshotImpl> currentInstance;
    private @GuardedBy(value={"this"}) ModuleInfoSnapshot currentSnapshot;
    private @GuardedBy(value={"this"}) int generation;
    private volatile boolean ignoreScanner = true;

    RegularYangModuleInfoRegistry(ComponentFactory<OSGiModuleInfoSnapshotImpl> contextFactory, YangParserFactory factory) {
        this.contextFactory = Objects.requireNonNull(contextFactory);
        this.resolver = new ModuleInfoSnapshotResolver("dom-schema-osgi", factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void scannerUpdate() {
        if (!this.ignoreScanner) {
            RegularYangModuleInfoRegistry regularYangModuleInfoRegistry = this;
            synchronized (regularYangModuleInfoRegistry) {
                this.updateService();
            }
        }
    }

    @Override
    synchronized void scannerShutdown() {
        this.ignoreScanner = true;
    }

    @Override
    synchronized void enableScannerAndUpdate() {
        this.ignoreScanner = false;
        this.updateService();
    }

    @Override
    synchronized void close() {
        this.ignoreScanner = true;
        if (this.currentInstance != null) {
            this.currentInstance.dispose();
            this.currentInstance = null;
        }
    }

    @Override
    Registration registerBundle(List<YangModuleInfo> moduleInfos, List<YangFeatureProvider<?>> featureProviders) {
        final List infoRegs = this.resolver.registerModuleInfos(moduleInfos);
        final ImmutableList featureRegs = (ImmutableList)featureProviders.stream().map(provider -> {
            YangFeatureProvider raw = provider;
            return this.resolver.registerModuleFeatures(raw.boundModule(), raw.supportedFeatures());
        }).collect(ImmutableList.toImmutableList());
        return new AbstractRegistration(){

            protected void removeRegistration() {
                featureRegs.forEach(Registration::close);
                infoRegs.forEach(Registration::close);
            }
        };
    }

    @Holding(value={"this"})
    private void updateService() {
        ModuleInfoSnapshot newSnapshot;
        try {
            newSnapshot = this.resolver.takeSnapshot();
        }
        catch (NoSuchElementException e) {
            LOG.debug("No snapshot available", (Throwable)e);
            return;
        }
        if (newSnapshot.equals(this.currentSnapshot)) {
            LOG.debug("No update to snapshot");
            return;
        }
        ComponentInstance newInstance = this.contextFactory.newInstance(OSGiModuleInfoSnapshotImpl.props(this.nextGeneration(), newSnapshot));
        if (this.currentInstance != null) {
            this.currentInstance.dispose();
        }
        this.currentInstance = newInstance;
        this.currentSnapshot = newSnapshot;
    }

    @Holding(value={"this"})
    private long nextGeneration() {
        return this.generation == -1 ? -1L : (long)(++this.generation);
    }
}

