/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.concurrent.EqualityQueuedNotificationManager;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryDOMStoreTreeChangePublisher
extends AbstractDOMStoreTreeChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMStoreTreeChangePublisher.class);
    private final EqualityQueuedNotificationManager<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> notificationManager;

    InMemoryDOMStoreTreeChangePublisher(String dsName, ExecutorService listenerExecutor, int maxQueueSize) {
        this.notificationManager = new EqualityQueuedNotificationManager("DataTreeChangeListenerQueueMgr + dsName", (Executor)listenerExecutor, maxQueueSize, (listener, notifications) -> {
            if (!listener.isClosed()) {
                ((DOMDataTreeChangeListener)listener.getInstance()).onDataTreeChanged((List)notifications);
            }
        });
    }

    private InMemoryDOMStoreTreeChangePublisher(EqualityQueuedNotificationManager<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> notificationManager) {
        this.notificationManager = notificationManager;
    }

    EqualityQueuedNotificationManager<?, ?> getNotificationManager() {
        return this.notificationManager;
    }

    protected void notifyListener(AbstractDOMDataTreeChangeListenerRegistration<?> registration, List<DataTreeCandidate> changes) {
        LOG.debug("Enqueueing candidates {} for registration {}", changes, registration);
        this.notificationManager.submitNotifications(registration, changes);
    }

    protected synchronized void registrationRemoved(AbstractDOMDataTreeChangeListenerRegistration<?> registration) {
        LOG.debug("Closing registration {}", registration);
    }

    <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener, DataTreeSnapshot snapshot) {
        AbstractDOMDataTreeChangeListenerRegistration reg = this.registerTreeChangeListener(treeId, listener);
        Optional preExistingData = snapshot.readNode(YangInstanceIdentifier.of());
        if (!preExistingData.isPresent()) {
            listener.onInitialData();
            return reg;
        }
        NormalizedNode data = (NormalizedNode)preExistingData.orElseThrow();
        if (treeId.isEmpty()) {
            Preconditions.checkState((boolean)(data instanceof DataContainerNode), (String)"Unexpected root node %s", (Object)data);
            if (((DataContainerNode)data).isEmpty()) {
                listener.onInitialData();
                return reg;
            }
        }
        DataTreeCandidate candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)YangInstanceIdentifier.of(), (NormalizedNode)data);
        InMemoryDOMStoreTreeChangePublisher publisher = new InMemoryDOMStoreTreeChangePublisher(this.notificationManager);
        publisher.registerTreeChangeListener(treeId, listener);
        if (!publisher.publishChange(candidate)) {
            listener.onInitialData();
        }
        return reg;
    }

    synchronized boolean publishChange(@NonNull DataTreeCandidate candidate) {
        return this.processCandidateTree(candidate);
    }
}

