/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.txchain;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.DomListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxchainDomWrite
extends DatastoreAbstractWriter
implements TransactionChainListener {
    private static final Logger LOG = LoggerFactory.getLogger(TxchainDomWrite.class);
    private final DOMDataBroker domDataBroker;
    private List<MapEntryNode> list;

    public TxchainDomWrite(DOMDataBroker domDataBroker, StartTestInput.Operation oper, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(oper, outerListElem, innerListElem, writesPerTx, dataStore);
        this.domDataBroker = domDataBroker;
        LOG.debug("Created TxchainDomWrite");
    }

    @Override
    public void createList() {
        this.list = DomListBuilder.buildOuterList(this.outerListElem, this.innerListElem);
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        YangInstanceIdentifier pid = YangInstanceIdentifier.builder().node(TestExec.QNAME).node(OuterList.QNAME).build();
        DOMTransactionChain chain = this.domDataBroker.createTransactionChain((TransactionChainListener)this);
        DOMDataWriteTransaction tx = chain.newWriteOnlyTransaction();
        int txSubmitted = 0;
        int writeCnt = 0;
        for (MapEntryNode element : this.list) {
            YangInstanceIdentifier yid = pid.node((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(OuterList.QNAME, element.getIdentifier().getKeyValues()));
            if (this.oper == StartTestInput.Operation.PUT) {
                tx.put(dsType, yid, (NormalizedNode)element);
            } else {
                tx.merge(dsType, yid, (NormalizedNode)element);
            }
            if ((long)(++writeCnt) != this.writesPerTx) continue;
            ++txSubmitted;
            Futures.addCallback((ListenableFuture)tx.submit(), (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(Void result) {
                    TxchainDomWrite.this.txOk++;
                }

                public void onFailure(Throwable t) {
                    LOG.error("Transaction failed, {}", t);
                    TxchainDomWrite.this.txError++;
                }
            });
            tx = chain.newWriteOnlyTransaction();
            writeCnt = 0;
        }
        try {
            ++txSubmitted;
            tx.submit().checkedGet();
            ++this.txOk;
        }
        catch (TransactionCommitFailedException e) {
            LOG.error("Transaction failed", (Throwable)e);
            ++this.txError;
        }
        try {
            chain.close();
        }
        catch (IllegalStateException e) {
            LOG.error("Transaction close failed,", (Throwable)e);
        }
        LOG.debug("Transactions: submitted {}, completed {}", (Object)txSubmitted, (Object)(this.txOk + this.txError));
    }

    public void onTransactionChainFailed(TransactionChain<?, ?> chain, AsyncTransaction<?, ?> transaction, Throwable cause) {
        LOG.error("Broken chain {} in TxchainDomWrite, transaction {}, cause {}", new Object[]{chain, transaction.getIdentifier(), cause});
    }

    public void onTransactionChainSuccessful(TransactionChain<?, ?> chain) {
        LOG.debug("Chain {} closed successfully", chain);
    }
}

