/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.listener;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.dsbenchmark.listener.DsbenchmarkListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsbenchmarkListenerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DsbenchmarkListenerProvider.class);
    private static final InstanceIdentifier<TestExec> TEST_EXEC_IID = InstanceIdentifier.builder(TestExec.class).build();
    private final List<ListenerRegistration<DsbenchmarkListener>> listeners = new ArrayList<ListenerRegistration<DsbenchmarkListener>>();
    private DataBroker dataBroker;

    public void setDataBroker(DataBroker dataBroker) {
        this.dataBroker = dataBroker;
        LOG.debug("DsbenchmarkListenerProvider created");
    }

    public void createAndRegisterListeners(int numListeners) {
        for (int i = 0; i < numListeners; ++i) {
            DsbenchmarkListener listener = new DsbenchmarkListener();
            this.listeners.add((ListenerRegistration<DsbenchmarkListener>)this.dataBroker.registerDataTreeChangeListener(new DataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, TEST_EXEC_IID), (DataTreeChangeListener)listener));
            this.listeners.add((ListenerRegistration<DsbenchmarkListener>)this.dataBroker.registerDataTreeChangeListener(new DataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, TEST_EXEC_IID), (DataTreeChangeListener)listener));
        }
        LOG.debug("DsbenchmarkListenerProvider created {} listeneres", (Object)numListeners);
    }

    public long getDataChangeCount() {
        long dataChanges = 0L;
        for (ListenerRegistration<DsbenchmarkListener> listenerRegistration : this.listeners) {
            dataChanges += (long)((DsbenchmarkListener)listenerRegistration.getInstance()).getNumDataChanges();
        }
        LOG.debug("DsbenchmarkListenerProvider , total data changes {}", (Object)dataChanges);
        return dataChanges;
    }

    public long getEventCountAndDestroyListeners() {
        long totalEvents = 0L;
        for (ListenerRegistration<DsbenchmarkListener> listenerRegistration : this.listeners) {
            totalEvents += (long)((DsbenchmarkListener)listenerRegistration.getInstance()).getNumEvents();
            listenerRegistration.close();
        }
        this.listeners.clear();
        LOG.debug("DsbenchmarkListenerProvider destroyed listeneres, total events {}", (Object)totalEvents);
        return totalEvents;
    }
}

