/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.simpletx;

import java.util.List;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.dsbenchmark.BaListBuilder;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpletxBaWrite
extends DatastoreAbstractWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpletxBaWrite.class);
    private final DataBroker dataBroker;
    private List<OuterList> list;

    public SimpletxBaWrite(DataBroker dataBroker, StartTestInput.Operation oper, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(oper, outerListElem, innerListElem, writesPerTx, dataStore);
        this.dataBroker = dataBroker;
        LOG.debug("Created SimpletxBaWrite");
    }

    @Override
    public void createList() {
        this.list = BaListBuilder.buildOuterList(this.outerListElem, this.innerListElem);
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        long writeCnt = 0L;
        for (OuterList element : this.list) {
            KeyedInstanceIdentifier iid = InstanceIdentifier.create(TestExec.class).child(OuterList.class, (Identifier)element.getKey());
            if (this.oper == StartTestInput.Operation.PUT) {
                tx.put(dsType, (InstanceIdentifier)iid, (DataObject)element);
            } else {
                tx.merge(dsType, (InstanceIdentifier)iid, (DataObject)element);
            }
            if (++writeCnt != this.writesPerTx) continue;
            try {
                tx.submit().checkedGet();
                ++this.txOk;
            }
            catch (TransactionCommitFailedException e) {
                LOG.error("Transaction failed: {}", (Throwable)e);
                ++this.txError;
            }
            tx = this.dataBroker.newWriteOnlyTransaction();
            writeCnt = 0L;
        }
        if (writeCnt != 0L) {
            try {
                tx.submit().checkedGet();
            }
            catch (TransactionCommitFailedException e) {
                LOG.error("Transaction failed: {}", (Throwable)e);
            }
        }
    }
}

