/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.simpletx;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.CheckedFuture;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.simpletx.SimpletxDomWrite;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpletxDomRead
extends DatastoreAbstractWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpletxDomRead.class);
    private final DOMDataBroker domDataBroker;

    public SimpletxDomRead(DOMDataBroker domDataBroker, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(StartTestInput.Operation.DELETE, outerListElem, innerListElem, writesPerTx, dataStore);
        this.domDataBroker = domDataBroker;
        LOG.debug("Created simpleTxDomRead");
    }

    @Override
    public void createList() {
        LOG.debug("SimpletxDomRead: creating data in the data store");
        SimpletxDomWrite dd = new SimpletxDomWrite(this.domDataBroker, StartTestInput.Operation.PUT, this.outerListElem, this.innerListElem, this.outerListElem, this.dataStore);
        dd.createList();
        dd.executeList();
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        QName olId = QName.create((QName)OuterList.QNAME, (String)"id");
        YangInstanceIdentifier pid = YangInstanceIdentifier.builder().node(TestExec.QNAME).node(OuterList.QNAME).build();
        try (DOMDataReadOnlyTransaction tx = this.domDataBroker.newReadOnlyTransaction();){
            for (int l = 0; l < this.outerListElem; ++l) {
                YangInstanceIdentifier yid = pid.node((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(OuterList.QNAME, olId, (Object)l));
                CheckedFuture submitFuture = tx.read(dsType, yid);
                try {
                    Optional optionalDataObject = (Optional)submitFuture.checkedGet();
                    if (optionalDataObject != null && optionalDataObject.isPresent()) {
                        NormalizedNode ret = (NormalizedNode)optionalDataObject.get();
                        LOG.trace("optionalDataObject is {}", (Object)ret);
                        ++this.txOk;
                        continue;
                    }
                    ++this.txError;
                    LOG.warn("optionalDataObject is either null or .isPresent is false");
                    continue;
                }
                catch (ReadFailedException e) {
                    LOG.warn("failed to ....", (Throwable)e);
                    ++this.txError;
                }
            }
        }
    }
}

