/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.simpletx;

import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.simpletx.SimpletxDomWrite;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpletxDomDelete
extends DatastoreAbstractWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpletxDomDelete.class);
    private final DOMDataBroker domDataBroker;

    public SimpletxDomDelete(DOMDataBroker domDataBroker, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(StartTestInput.Operation.DELETE, outerListElem, innerListElem, writesPerTx, dataStore);
        this.domDataBroker = domDataBroker;
        LOG.debug("Created simpleTxDomDelete");
    }

    @Override
    public void createList() {
        LOG.debug("SimpletxDomDelete: creating data in the data store");
        SimpletxDomWrite dd = new SimpletxDomWrite(this.domDataBroker, StartTestInput.Operation.PUT, this.outerListElem, this.innerListElem, this.outerListElem, this.dataStore);
        dd.createList();
        dd.executeList();
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        QName olId = QName.create((QName)OuterList.QNAME, (String)"id");
        YangInstanceIdentifier pid = YangInstanceIdentifier.builder().node(TestExec.QNAME).node(OuterList.QNAME).build();
        DOMDataWriteTransaction tx = this.domDataBroker.newWriteOnlyTransaction();
        long writeCnt = 0L;
        for (int l = 0; l < this.outerListElem; ++l) {
            YangInstanceIdentifier yid = pid.node((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(OuterList.QNAME, olId, (Object)l));
            tx.delete(dsType, yid);
            if (++writeCnt != this.writesPerTx) continue;
            try {
                tx.submit().checkedGet();
                ++this.txOk;
            }
            catch (TransactionCommitFailedException e) {
                LOG.error("Transaction failed: {}", (Throwable)e);
                ++this.txError;
            }
            tx = this.domDataBroker.newWriteOnlyTransaction();
            writeCnt = 0L;
        }
        if (writeCnt != 0L) {
            try {
                tx.submit().checkedGet();
            }
            catch (TransactionCommitFailedException e) {
                LOG.error("Transaction failed: {}", (Throwable)e);
            }
        }
    }
}

