/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.txchain;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.opendaylight.controller.md.sal.binding.api.BindingTransactionChain;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.dsbenchmark.BaListBuilder;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxchainBaWrite
extends DatastoreAbstractWriter
implements TransactionChainListener {
    private static final Logger LOG = LoggerFactory.getLogger(TxchainBaWrite.class);
    private final DataBroker bindingDataBroker;
    private List<OuterList> list;

    public TxchainBaWrite(DataBroker bindingDataBroker, StartTestInput.Operation oper, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(oper, outerListElem, innerListElem, writesPerTx, dataStore);
        this.bindingDataBroker = bindingDataBroker;
        LOG.debug("Created TxchainBaWrite");
    }

    @Override
    public void createList() {
        this.list = BaListBuilder.buildOuterList(this.outerListElem, this.innerListElem);
    }

    @Override
    public void executeList() {
        BindingTransactionChain chain = this.bindingDataBroker.createTransactionChain((TransactionChainListener)this);
        LogicalDatastoreType dsType = this.getDataStoreType();
        WriteTransaction tx = chain.newWriteOnlyTransaction();
        int txSubmitted = 0;
        int writeCnt = 0;
        for (OuterList element : this.list) {
            KeyedInstanceIdentifier iid = InstanceIdentifier.create(TestExec.class).child(OuterList.class, (Identifier)element.getKey());
            if (this.oper == StartTestInput.Operation.PUT) {
                tx.put(dsType, (InstanceIdentifier)iid, (DataObject)element);
            } else {
                tx.merge(dsType, (InstanceIdentifier)iid, (DataObject)element);
            }
            if ((long)(++writeCnt) != this.writesPerTx) continue;
            ++txSubmitted;
            Futures.addCallback((ListenableFuture)tx.submit(), (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(Void result) {
                    TxchainBaWrite.this.txOk++;
                }

                public void onFailure(Throwable t) {
                    LOG.error("Transaction failed, {}", t);
                    TxchainBaWrite.this.txError++;
                }
            });
            tx = chain.newWriteOnlyTransaction();
            writeCnt = 0;
        }
        try {
            ++txSubmitted;
            tx.submit().checkedGet();
            ++this.txOk;
        }
        catch (TransactionCommitFailedException e) {
            LOG.error("Transaction failed", (Throwable)e);
            ++this.txError;
        }
        try {
            chain.close();
        }
        catch (IllegalStateException e) {
            LOG.error("Transaction close failed,", (Throwable)e);
        }
        LOG.debug("Transactions: submitted {}, completed {}", (Object)txSubmitted, (Object)(this.txOk + this.txError));
    }

    public void onTransactionChainFailed(TransactionChain<?, ?> chain, AsyncTransaction<?, ?> transaction, Throwable cause) {
        LOG.error("Broken chain {} in DatastoreBaAbstractWrite, transaction {}, cause {}", new Object[]{chain, transaction.getIdentifier(), cause});
    }

    public void onTransactionChainSuccessful(TransactionChain<?, ?> chain) {
        LOG.debug("DatastoreBaAbstractWrite closed successfully, chain {}", chain);
    }
}

