/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.listener.DsbenchmarkListenerProvider;
import org.opendaylight.dsbenchmark.simpletx.SimpletxBaDelete;
import org.opendaylight.dsbenchmark.simpletx.SimpletxBaRead;
import org.opendaylight.dsbenchmark.simpletx.SimpletxBaWrite;
import org.opendaylight.dsbenchmark.simpletx.SimpletxDomDelete;
import org.opendaylight.dsbenchmark.simpletx.SimpletxDomRead;
import org.opendaylight.dsbenchmark.simpletx.SimpletxDomWrite;
import org.opendaylight.dsbenchmark.txchain.TxchainBaDelete;
import org.opendaylight.dsbenchmark.txchain.TxchainBaRead;
import org.opendaylight.dsbenchmark.txchain.TxchainBaWrite;
import org.opendaylight.dsbenchmark.txchain.TxchainDomDelete;
import org.opendaylight.dsbenchmark.txchain.TxchainDomRead;
import org.opendaylight.dsbenchmark.txchain.TxchainDomWrite;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.CleanupStoreInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.CleanupStoreOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.CleanupStoreOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.DsbenchmarkService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExecBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestStatusBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsbenchmarkProvider
implements DsbenchmarkService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DsbenchmarkProvider.class);
    private static final InstanceIdentifier<TestExec> TEST_EXEC_IID = InstanceIdentifier.builder(TestExec.class).build();
    private static final InstanceIdentifier<TestStatus> TEST_STATUS_IID = InstanceIdentifier.builder(TestStatus.class).build();
    private final AtomicReference<TestStatus.ExecStatus> execStatus = new AtomicReference<TestStatus.ExecStatus>(TestStatus.ExecStatus.Idle);
    private final DsbenchmarkListenerProvider listenerProvider = new DsbenchmarkListenerProvider();
    private final DOMDataBroker domDataBroker;
    private final DataBroker dataBroker;
    private long testsCompleted = 0L;

    public DsbenchmarkProvider(DOMDataBroker domDataBroker, DataBroker dataBroker) {
        this.domDataBroker = domDataBroker;
        this.dataBroker = dataBroker;
    }

    public void init() {
        this.listenerProvider.setDataBroker(this.dataBroker);
        try {
            this.setTestOperData(this.execStatus.get(), this.testsCompleted);
        }
        catch (Exception e) {
            LOG.warn("Working around Bugs 8829 and 6793 by ignoring exception from setTestOperData: {}", (Throwable)e);
        }
        LOG.info("DsbenchmarkProvider initiated");
    }

    @Override
    public void close() {
        LOG.info("DsbenchmarkProvider closed");
    }

    public ListenableFuture<RpcResult<CleanupStoreOutput>> cleanupStore(CleanupStoreInput input) {
        this.cleanupTestStore();
        LOG.debug("Data Store cleaned up");
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)new CleanupStoreOutputBuilder().build()).build());
    }

    public ListenableFuture<RpcResult<StartTestOutput>> startTest(StartTestInput input) {
        long execTime;
        LOG.info("Starting the data store benchmark test, input: {}", (Object)input);
        if (!this.execStatus.compareAndSet(TestStatus.ExecStatus.Idle, TestStatus.ExecStatus.Executing)) {
            LOG.info("Test in progress");
            return RpcResultBuilder.success((Object)new StartTestOutputBuilder().setStatus(StartTestOutput.Status.TESTINPROGRESS).build()).buildFuture();
        }
        this.cleanupTestStore();
        DatastoreAbstractWriter dsWriter = this.getDatastoreWriter(input);
        this.listenerProvider.createAndRegisterListeners(input.getListeners().intValue());
        long startTime = System.nanoTime();
        dsWriter.createList();
        long endTime = System.nanoTime();
        long listCreateTime = (endTime - startTime) / 1000L;
        try {
            startTime = System.nanoTime();
            dsWriter.executeList();
            endTime = System.nanoTime();
            execTime = (endTime - startTime) / 1000L;
            ++this.testsCompleted;
        }
        catch (Exception e) {
            LOG.error("Test error: {}", (Object)e.toString());
            this.execStatus.set(TestStatus.ExecStatus.Idle);
            return RpcResultBuilder.success((Object)new StartTestOutputBuilder().setStatus(StartTestOutput.Status.FAILED).build()).buildFuture();
        }
        LOG.info("Test finished");
        this.setTestOperData(TestStatus.ExecStatus.Idle, this.testsCompleted);
        this.execStatus.set(TestStatus.ExecStatus.Idle);
        long numDataChanges = this.listenerProvider.getDataChangeCount();
        long numEvents = this.listenerProvider.getEventCountAndDestroyListeners();
        StartTestOutput output = new StartTestOutputBuilder().setStatus(StartTestOutput.Status.OK).setListBuildTime(Long.valueOf(listCreateTime)).setExecTime(Long.valueOf(execTime)).setTxOk(Long.valueOf(dsWriter.getTxOk())).setNtfOk(Long.valueOf(numEvents)).setDataChangeEventsOk(Long.valueOf(numDataChanges)).setTxError(Long.valueOf(dsWriter.getTxError())).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    private void setTestOperData(TestStatus.ExecStatus sts, long tstCompl) {
        TestStatus status = new TestStatusBuilder().setExecStatus(sts).setTestsCompleted(Long.valueOf(tstCompl)).build();
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, TEST_STATUS_IID, (DataObject)status);
        try {
            tx.commit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
        LOG.debug("DataStore test oper status populated: {}", (Object)status);
    }

    private void cleanupTestStore() {
        TestExec data = new TestExecBuilder().setOuterList(Collections.emptyList()).build();
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.CONFIGURATION, TEST_EXEC_IID, (DataObject)data);
        try {
            tx.commit().get();
            LOG.debug("DataStore config test data cleaned up");
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.info("Failed to cleanup DataStore configtest data");
            throw new IllegalStateException(e);
        }
        tx = this.dataBroker.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, TEST_EXEC_IID, (DataObject)data);
        try {
            tx.commit().get();
            LOG.debug("DataStore operational test data cleaned up");
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.info("Failed to cleanup DataStore operational test data");
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatastoreAbstractWriter getDatastoreWriter(StartTestInput input) {
        DatastoreAbstractWriter retVal;
        StartTestInput.TransactionType txType = input.getTransactionType();
        StartTestInput.Operation oper = input.getOperation();
        StartTestInput.DataFormat dataFormat = input.getDataFormat();
        StartTestInput.DataStore dataStore = input.getDataStore();
        int outerListElem = input.getOuterElements().intValue();
        int innerListElem = input.getInnerElements().intValue();
        int writesPerTx = input.getPutsPerTx().intValue();
        try {
            retVal = txType == StartTestInput.TransactionType.SIMPLETX ? (dataFormat == StartTestInput.DataFormat.BINDINGAWARE ? (StartTestInput.Operation.DELETE == oper ? new SimpletxBaDelete(this.dataBroker, outerListElem, innerListElem, (long)writesPerTx, dataStore) : (StartTestInput.Operation.READ == oper ? new SimpletxBaRead(this.dataBroker, outerListElem, innerListElem, (long)writesPerTx, dataStore) : new SimpletxBaWrite(this.dataBroker, oper, outerListElem, innerListElem, writesPerTx, dataStore))) : (StartTestInput.Operation.DELETE == oper ? new SimpletxDomDelete(this.domDataBroker, outerListElem, innerListElem, (long)writesPerTx, dataStore) : (StartTestInput.Operation.READ == oper ? new SimpletxDomRead(this.domDataBroker, outerListElem, innerListElem, (long)writesPerTx, dataStore) : new SimpletxDomWrite(this.domDataBroker, oper, outerListElem, innerListElem, writesPerTx, dataStore)))) : (dataFormat == StartTestInput.DataFormat.BINDINGAWARE ? (StartTestInput.Operation.DELETE == oper ? new TxchainBaDelete(this.dataBroker, outerListElem, innerListElem, (long)writesPerTx, dataStore) : (StartTestInput.Operation.READ == oper ? new TxchainBaRead(this.dataBroker, outerListElem, innerListElem, (long)writesPerTx, dataStore) : new TxchainBaWrite(this.dataBroker, oper, outerListElem, innerListElem, writesPerTx, dataStore))) : (StartTestInput.Operation.DELETE == oper ? new TxchainDomDelete(this.domDataBroker, outerListElem, innerListElem, (long)writesPerTx, dataStore) : (StartTestInput.Operation.READ == oper ? new TxchainDomRead(this.domDataBroker, outerListElem, innerListElem, (long)writesPerTx, dataStore) : new TxchainDomWrite(this.domDataBroker, oper, outerListElem, innerListElem, writesPerTx, dataStore))));
        }
        finally {
            this.execStatus.set(TestStatus.ExecStatus.Idle);
        }
        return retVal;
    }
}

