/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.listener;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yangtools.binding.ExactDataObjectStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsbenchmarkListener
implements DataTreeChangeListener<TestExec> {
    private static final Logger LOG = LoggerFactory.getLogger(DsbenchmarkListener.class);
    private final AtomicInteger numEvents = new AtomicInteger(0);
    private final AtomicInteger numDataChanges = new AtomicInteger(0);

    public void onDataTreeChanged(List<DataTreeModification<TestExec>> changes) {
        int eventNum = this.numEvents.incrementAndGet();
        this.numDataChanges.addAndGet(changes.size());
        if (LOG.isDebugEnabled()) {
            DsbenchmarkListener.logDataTreeChangeEvent(eventNum, changes);
        }
    }

    private static synchronized void logDataTreeChangeEvent(int eventNum, List<DataTreeModification<TestExec>> changes) {
        LOG.debug("DsbenchmarkListener-onDataTreeChanged: Event {}", (Object)eventNum);
        for (DataTreeModification<TestExec> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            DataObjectModification.ModificationType modType = rootNode.modificationType();
            ExactDataObjectStep changeId = rootNode.step();
            Collection modifications = rootNode.modifiedChildren();
            LOG.debug("    changeId {}, modType {}, mods: {}", new Object[]{changeId, modType, modifications.size()});
            for (DataObjectModification mod : modifications) {
                LOG.debug("      mod-getDataAfter: {}", (Object)mod.dataAfter());
            }
        }
    }

    public int getNumEvents() {
        return this.numEvents.get();
    }

    public int getNumDataChanges() {
        return this.numDataChanges.get();
    }
}

