/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.txchain;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.DomListBuilder;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxchainDomWrite
extends DatastoreAbstractWriter
implements FutureCallback<Empty> {
    private static final Logger LOG = LoggerFactory.getLogger(TxchainDomWrite.class);
    private final DOMDataBroker dataBroker;
    private List<MapEntryNode> list = null;

    public TxchainDomWrite(DOMDataBroker dataBroker, StartTestInput.Operation oper, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(oper, outerListElem, innerListElem, writesPerTx, dataStore);
        this.dataBroker = dataBroker;
        LOG.debug("Created TxchainDomWrite");
    }

    @Override
    public void createList() {
        this.list = DomListBuilder.buildOuterList(this.outerListElem, this.innerListElem);
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        YangInstanceIdentifier pid = YangInstanceIdentifier.of((QName[])new QName[]{TestExec.QNAME, OuterList.QNAME});
        DOMTransactionChain chain = this.dataBroker.createMergingTransactionChain();
        chain.addCallback((FutureCallback)this);
        DOMDataTreeWriteTransaction tx = chain.newWriteOnlyTransaction();
        int txSubmitted = 0;
        int writeCnt = 0;
        for (MapEntryNode element : this.list) {
            YangInstanceIdentifier yid = pid.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)OuterList.QNAME, (Map)element.name().asMap()));
            if (this.oper == StartTestInput.Operation.PUT) {
                tx.put(dsType, yid, (NormalizedNode)element);
            } else {
                tx.merge(dsType, yid, (NormalizedNode)element);
            }
            if ((long)(++writeCnt) != this.writesPerTx) continue;
            ++txSubmitted;
            tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

                public void onSuccess(CommitInfo result) {
                    TxchainDomWrite.this.txOk++;
                }

                public void onFailure(Throwable cause) {
                    LOG.error("Transaction failed", cause);
                    TxchainDomWrite.this.txError++;
                }
            }, MoreExecutors.directExecutor());
            tx = chain.newWriteOnlyTransaction();
            writeCnt = 0;
        }
        try {
            ++txSubmitted;
            tx.commit().get();
            ++this.txOk;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Transaction failed", (Throwable)e);
            ++this.txError;
        }
        try {
            chain.close();
        }
        catch (IllegalStateException e) {
            LOG.error("Transaction close failed,", (Throwable)e);
        }
        LOG.debug("Transactions: submitted {}, completed {}", (Object)txSubmitted, (Object)(this.txOk + this.txError));
    }

    public void onFailure(Throwable cause) {
        LOG.error("Broken chain in TxchainDomWrite", cause);
    }

    public void onSuccess(Empty result) {
        LOG.debug("Chain closed successfully");
    }
}

