/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark;

import java.util.Random;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatastoreAbstractWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreAbstractWriter.class);
    protected final int outerListElem;
    protected final int innerListElem;
    protected final long writesPerTx;
    protected final StartTestInput.Operation oper;
    protected final StartTestInput.DataStore dataStore;
    protected final Random rn = new Random();
    protected int txOk = 0;
    protected int txError = 0;

    public DatastoreAbstractWriter(StartTestInput.Operation oper, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        this.outerListElem = outerListElem;
        this.innerListElem = innerListElem;
        this.writesPerTx = writesPerTx;
        this.oper = oper;
        this.dataStore = dataStore;
        LOG.debug("DatastoreAbstractWriter created: {}", (Object)this);
    }

    public abstract void createList();

    public abstract void executeList();

    public int getTxError() {
        return this.txError;
    }

    public int getTxOk() {
        return this.txOk;
    }

    protected LogicalDatastoreType getDataStoreType() {
        LogicalDatastoreType dsType = this.dataStore == StartTestInput.DataStore.CONFIG ? LogicalDatastoreType.CONFIGURATION : (this.dataStore == StartTestInput.DataStore.OPERATIONAL ? LogicalDatastoreType.OPERATIONAL : (this.rn.nextBoolean() ? LogicalDatastoreType.OPERATIONAL : LogicalDatastoreType.CONFIGURATION));
        return dsType;
    }
}

