/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.txchain;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.dsbenchmark.BaListBuilder;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Empty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxchainBaWrite
extends DatastoreAbstractWriter
implements FutureCallback<Empty> {
    private static final Logger LOG = LoggerFactory.getLogger(TxchainBaWrite.class);
    private final DataBroker dataBroker;
    private List<OuterList> list = null;

    public TxchainBaWrite(DataBroker dataBroker, StartTestInput.Operation oper, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(oper, outerListElem, innerListElem, writesPerTx, dataStore);
        this.dataBroker = Objects.requireNonNull(dataBroker);
        LOG.debug("Created TxchainBaWrite");
    }

    @Override
    public void createList() {
        this.list = BaListBuilder.buildOuterList(this.outerListElem, this.innerListElem);
    }

    @Override
    public void executeList() {
        TransactionChain chain = this.dataBroker.createMergingTransactionChain();
        chain.addCallback((FutureCallback)this);
        LogicalDatastoreType dsType = this.getDataStoreType();
        WriteTransaction tx = chain.newWriteOnlyTransaction();
        int txSubmitted = 0;
        int writeCnt = 0;
        for (OuterList element : this.list) {
            KeyedInstanceIdentifier iid = InstanceIdentifier.create(TestExec.class).child(OuterList.class, (Key)element.key());
            if (this.oper == StartTestInput.Operation.PUT) {
                tx.put(dsType, (InstanceIdentifier)iid, (DataObject)element);
            } else {
                tx.merge(dsType, (InstanceIdentifier)iid, (DataObject)element);
            }
            if ((long)(++writeCnt) != this.writesPerTx) continue;
            ++txSubmitted;
            tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

                public void onSuccess(CommitInfo result) {
                    TxchainBaWrite.this.txOk++;
                }

                public void onFailure(Throwable cause) {
                    LOG.error("Transaction failed", cause);
                    TxchainBaWrite.this.txError++;
                }
            }, MoreExecutors.directExecutor());
            tx = chain.newWriteOnlyTransaction();
            writeCnt = 0;
        }
        try {
            ++txSubmitted;
            tx.commit().get();
            ++this.txOk;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Transaction failed", (Throwable)e);
            ++this.txError;
        }
        try {
            chain.close();
        }
        catch (IllegalStateException e) {
            LOG.error("Transaction close failed,", (Throwable)e);
        }
        LOG.debug("Transactions: submitted {}, completed {}", (Object)txSubmitted, (Object)(this.txOk + this.txError));
    }

    public void onFailure(Throwable cause) {
        LOG.error("Broken chain in DatastoreBaAbstractWrite", cause);
    }

    public void onSuccess(Empty result) {
        LOG.debug("DatastoreBaAbstractWrite closed successfully");
    }
}

